/* #include "wavelet.h" */
#include "dau_wave.h"

/******************************************************************
*              (c) Copyright  1997                                *
*                         by                                      *
*  Author: Rene Carmona, Bruno Torresani, Wen L. Hwang, A. Wang   *
*                 Princeton University                            *
*                 All right reserved                              *
******************************************************************/

#include "Swave.h"
/*****************************************************************************/

/*  These constants are not used in the program.
#define pi 3.141592653589793
#define NW         6        
#define XMIN       -1.0
#define XMAX       14
#define NPT        200	
#define TWOTEN     1024 
#define TWOFIVE    512  
*/

/*  NMIN and NMAX are defined in dau_wave.h
#define NMIN       2
#define NMAX       10
*/

#define NMAXPLUS1  11
#define NITER      8    /* Number of iterations to compute the final array of a's */
#define TwoToNITER 256
#define SQR2       1.4142135

/*****************************************************************************/

int taille;		/* largest index of a nonzero a */

/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*	        BEGINNING OF WAVE_COEF.C                                     */
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
        
int open_read()
{
  int n;
  int i,j;

  c = (double **)malloc(NMAXPLUS1*sizeof(double *));
  for (n=NMIN;n<NMAX+1;n++)
    c[n] = (double *)malloc(2*n*sizeof(double));

  c[2][0] =  .482962913145;  c[2][1] = .836516303738;   c[2][2] = .224143868042;    
  c[2][3] = -.129409522551;    

  c[3][0] =  .332670552950;  c[3][1] =  .806891509311;  c[3][2] = .459877502118;   
  c[3][3] = -.135011020010;  c[3][4] = -.085441273882;  c[3][5] = .035226291882;    
  
  c[4][0] =  .230377813309;  c[4][1] =  .714846570553;  c[4][2] = .630880767930;    
  c[4][3] = -.027983769417;  c[4][4] = -.187034811719;  c[4][5] = .030841381836;    
  c[4][6] =  .032883011667;  c[4][7] = -.010597401785;   
  
  c[5][0] =  .160102397974;  c[5][1] =  .603829269797;  c[5][2] =  .724308528438;  
  c[5][3] =  .138428143901;  c[5][4] = -.242294887066;  c[5][5] = -.032244869585;  
  c[5][6] =  .077571493840;  c[5][7] = -.006241490213;  c[5][8] = -.012580751999;  
  c[5][9] =  .003335725285;    
  
  c[6][0] =  .111540743350;  c[6][1]  =  .494623890398; c[6][2]  =  .751133908021;  
  c[6][3] =  .315250351709;  c[6][4]  = -.226264693965; c[6][5]  = -.129766967567;  
  c[6][6] =  .097501605587;  c[6][7]  =  .027522865530; c[6][8]  = -.031582039318;  
  c[6][9] =  .000553842201;  c[6][10] =  .004777257511; c[6][11] = -.001077301085;  
  
  c[7][0]  =  .077852054085; c[7][1]  =  .396539319482; c[7][2]  =  .729132090846;  
  c[7][3]  =  .469782287405; c[7][4]  = -.143906003929; c[7][5]  = -.224036184994;  
  c[7][6]  =  .071309219267; c[7][7]  =  .080612609151; c[7][8]  = -.038029936935;  
  c[7][9]  = -.016574541631; c[7][10] =  .012550998556; c[7][11] =  .000429577973;  
  c[7][12] = -.001801640704; c[7][13] =  .000353713800;    
    
  c[8][0]  =  .054415842243; c[8][1]  =  .312871590914; c[8][2]  =  .675630736297;  
  c[8][3]  =  .585354683654; c[8][4]  = -.015829105256; c[8][5]  = -.284015542962;  
  c[8][6]  =  .000472484574; c[8][7]  =  .128747426620; c[8][8]  = -.017369301002;  
  c[8][9]  = -.044088253931; c[8][10] =  .013981027917; c[8][11] =  .008746094047;
  c[8][12] = -.004870352995; c[8][13] = -.000391740373; c[8][14] =  .000675449406; 
  c[8][15] = -.000117476784;    
  
  c[9][0]  =  .038077947364; c[9][1]  =  .243834674613; c[9][2]  =  .604823123690;  
  c[9][3]  =  .657288078051; c[9][4]  =  .133197385825; c[9][5]  = -.293273783279;  
  c[9][6]  = -.096840783223; c[9][7]  =  .148540749338; c[9][8]  =  .030725681479;  
  c[9][9]  = -.067632829061; c[9][10] =  .000250947115; c[9][11] =  .022361662124;  
  c[9][12] = -.004723204758; c[9][13] = -.004881503682; c[9][14] =  .001847646883; 
  c[9][15] =  .000230385764; c[9][16] = -.000251963189; c[9][17] =  .000039347320;
  
  
  c[10][0]  =  .026670057901;c[10][1]  =  .188176800078; c[10][2]  =  .527201188932;
  c[10][3]  =  .688459039454;c[10][4]  =  .281172343661; c[10][5]  = -.249846424327;
  c[10][6]  = -.195946274377;c[10][7]  =  .127369340336; c[10][8]  =  .093057364604;
  c[10][9]  = -.071394147166;c[10][10] = -.029457536822; c[10][11] =  .033212674059;
  c[10][12] =  .003606553567;c[10][13] = -.010733175483; c[10][14] =  .001395351747;
  c[10][15] =  .001992405295;c[10][16] = -.000685856695; c[10][17] = -.000116466855;
  c[10][18] =  .000093588670;c[10][19] = -.000013264203;    
 
}   /* End of the open_read() function */

/***************************************************************/
/**              Computation of the coef. of a                **/
/***************************************************************/

int compute_a()
{
  int 	i,j,ii;
  double *tmpa;

  taille = 0;
  a = (double *)malloc((1+taille)*sizeof(double)); 
  for (i=0;i<1+taille;i++)
    a[i] = 1;
  for(ii=0 ; ii < NITER ; ii++)
  {
    tmpa = (double *)malloc((1+taille)*sizeof(double)); 
    for (i=0;i<1+taille;i++)
      tmpa[i] = a[i];
    taille = 2 * taille + 2 * NW -1;		
    free(a);
    a = (double *)malloc((1+taille)*sizeof(double)); 
    for (i=0;i<1+taille;i++)
    { 
      a[i] = 0;
      for(j=0; j<1+(taille - 2*NW+1)/2 ; j++)
  	if((i-2*j<2*NW)&&(i-2*j>=0))	
 	  a[i] += c[NW][i-2*j] * tmpa[j];
 	  a[i] *= SQR2;
    }
    free(tmpa);
  }	
}

/***********************************************************/
/**           phi & psi wavelet computation               **/
/**     						  **/
/**	Uses the array a computed in the main program	  **/
/***********************************************************/

double phi(x)
double x;
{
  if ( (x < 0.0) || (x >= (taille+1)/TwoToNITER) )
    return 0.0;
  else
    return a[(int)floor(TwoToNITER*x)];
}

/***************************************************************/

double Psi(x)
double x;
{
  int  i;
  double tmp, minus;
	
  tmp = 0; minus = 1.0;
  for( i=0 ; i < 2*NW ; i++ )
  {
    minus *= -1.0;
    tmp += minus * c[NW][i] * phi(2 * x + i -1);
  }
  return (SQR2 * tmp);
}

/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/
/*		END OF WAVE_COEF.C                                           */
/*&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*/

/*****************************************************************************/
/*	INITIALIZE TWOTO	                                             */
/*****************************************************************************/

void init_twoto( max_resoln )
int max_resoln;
{
  int j;

  twoto = (int *) malloc((max_resoln+1) * sizeof(int));
  twoto[0] = 1;
  for ( j = 1; j <= max_resoln; j++ )
    twoto[j] = 2*twoto[j-1];
}

/****************************************************************************/
/*	INITIALIZE PHI ARRAY		    			            */
/****************************************************************************/

void init_phi_array( phi_array, max_resoln )
float **phi_array;
int max_resoln;
{
  float inc = 1.0 / pow( 2.0, (float) max_resoln );
  int array_size = (2*NW-1) * twoto[max_resoln] +1;
  float arg;
  int i;

  *phi_array = (float *) malloc( array_size * sizeof(float) );  
  for ( arg = 0.0, i = 0; i < array_size; arg += inc, i++ )
    (*phi_array)[i] = (float) phi( arg );
}

/****************************************************************************/
/*	INITIALIZE PSI ARRAY					            */
/****************************************************************************/

void init_psi_array( psi_array, max_resoln )
float **psi_array;
int max_resoln;
{
  float inc = 1.0 / pow( 2.0, (float) max_resoln );
  int array_size = (2*NW -1) * twoto[max_resoln] +1;
  float arg;
  int i;

  *psi_array = (float *) malloc( array_size * sizeof(float) );  
  for ( arg = 0.0, i = 0; i < array_size; arg += inc, i++ )
    (*psi_array)[i] = (float) Psi( arg - NW );
}

