\name{FS.nearOpt.fvprs.FRST}
\alias{FS.nearOpt.fvprs.FRST}
\title{The near-optimal reduction algorithm based on fuzzy rough set theory}
\usage{
FS.nearOpt.fvprs.FRST(decision.table, alpha.precision = 0.05, ...)
}
\arguments{
  \item{decision.table}{a \code{"DecisionTable"} class
  representing the decision table. See
  \code{\link{SF.asDecisionTable}}.  In this case, the
  decision attribute must be nominal.}

  \item{alpha.precision}{a numeric value representing
  variable precision of FVPRS.

  See \code{\link{BC.LU.approximation.FRST}}.}

  \item{...}{other parameters.}
}
\value{
A class \code{"FeatureSubset"} that contains the following
components: \itemize{ \item \code{reduct}: a list
representing a single reduct. In this case, it could be a
superreduct or just a subset of features. \item
\code{type.method}: a string representing the type of
method which is \code{"near.optimal.fvprs"}. \item
\code{type.task}: a string showing the type of task which
is \code{"feature selection"}. \item \code{model}: a string
representing the type of model. In this case, it is
\code{"FRST"} which means fuzzy rough set theory. }
}
\description{
This is a function implementing the near-optimal reduction
algorithm by employing fuzzy variable precision rough sets
(FVPRS) for feature selection based on FRST proposed by
(Zhao et al, 2009).
}
\details{
The near-optimal algorithm is an algorithm to find one
reduct only rather than all reducts. It modifies the
\eqn{\alpha}-reduction based on discernibility matrix by
using a heuristic algorithm. To get basic knowledge about
discernibility matrix, users can refers to the
\code{"alpha.red"} discernibility type in
\code{\link{BC.discernibility.mat.FRST}} .

It should be noted that this function does not give the new
decision table directly. The other additional function
called \code{\link{SF.applyDecTable}} is used to produce
the new decision table based on information about the
reduct from this function.
}
\examples{
#########################################################
## Example 1: Hiring dataset containing 8 objects with 5 attributes
#########################################################
data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## get reduct as FeatureSubset class
reduct.1 <- FS.nearOpt.fvprs.FRST(decision.table)

## get new decision table according to the reduct
new.decTable <- SF.applyDecTable(decision.table, reduct.1)

#########################################################
## Example 2: Pima dataset containing 7 objects with 9 attributes
#########################################################
data(RoughSetData)
decision.table <- RoughSetData$pima7.dt

## get reduct
reduct.2 <- FS.nearOpt.fvprs.FRST(decision.table)

## get new decision table according to the reduct
new.decTable <- SF.applyDecTable(decision.table, reduct.2)
}
\references{
S. Zhao, E. C. C. Tsang, and D. Chen, "The Model of Fuzzy
Variable Precision Rough Sets", IEEE Trans. on Fuzzy
Systems, vol. 17, no. 2, p. 451 - 467 (2009).
}
\seealso{
\code{\link{BC.discernibility.mat.FRST}}
}

