\name{FS.reduct.computation}
\alias{FS.reduct.computation}
\title{The reduct computation methods based on RST and FRST}
\usage{
  FS.reduct.computation(decision.table,
    method = "greedy.heuristic", ...)
}
\arguments{
  \item{decision.table}{a \code{"DecisionTable"} class
  representing the decision table. See
  \code{\link{SF.asDecisionTable}}.}

  \item{method}{a character representing the type of
  methods. See in Section \code{Details}.}

  \item{...}{other parameters. See the parameters on
  \code{\link{FS.greedy.heuristic.reduct.RST}},

  \code{\link{FS.nearOpt.fvprs.FRST}} and
  \code{\link{FS.permutation.heuristic.reduct.RST}}.}
}
\value{
  A class \code{"FeatureSubset"}. See
  \code{\link{FS.greedy.heuristic.reduct.RST}}

  or \code{\link{FS.nearOpt.fvprs.FRST}}.
}
\description{
  It is an additional function aimed as wrapper of
  approaches calculating a reduct.
}
\details{
  There exist three methods considered in this function
  based on RST and FRST as follows: \itemize{ \item
  \code{"greedy.heuristic"}: it is the greedy heuristic
  method based on RST.

  See \code{\link{FS.greedy.heuristic.reduct.RST}}. \item
  \code{"nearOpt.fvprs"}: it is the near-optimal reduction
  algorithm based on FRST.

  See \code{\link{FS.nearOpt.fvprs.FRST}}. \item
  \code{"permutation.heuristic"}: it is the permutation
  heuristic approach based on RST.

  See \code{\link{FS.permutation.heuristic.reduct.RST}}. }
  Those methods can be selected by assigning the parameter
  \code{method}. Additionally,
  \code{\link{SF.applyDecTable}} has been provided to
  generate the new decision table.
}
\examples{
##############################################################
## Example 1: generate reduct and new decision table
## using RST and FRST
##############################################################
data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## generate single reduct using RST
reduct.1 <- FS.reduct.computation(decision.table, method = "permutation.heuristic")

## generate single reduct using FRST
reduct.2 <- FS.reduct.computation(decision.table, method = "nearOpt.fvprs")

## generate new decision table according to the reduct.1
new.decTable.1 <- SF.applyDecTable(decision.table, reduct.1)

## generate new decision table according to the reduct.2
new.decTable.2 <- SF.applyDecTable(decision.table, reduct.2)
}
\seealso{
  \code{\link{D.discretization.RST}},
  \code{\link{BC.LU.approximation.RST}}
}

