% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getnlfilename.R
\name{getNlTileZipLclNameVIIRS}
\alias{getNlTileZipLclNameVIIRS}
\title{Constructs the filename used to save/access the downloaded VIIRS tile .tgz file}
\usage{
getNlTileZipLclNameVIIRS(nlType,
  configName = pkgOptions(paste0("configName_", nlType)), nlPeriod,
  tileNum)
}
\arguments{
\item{nlType}{The particular VIIRS type e.g. VIIRS.D for daily VIIRS}

\item{configName}{character the type of raster being processed}

\item{nlPeriod}{The nlPeriod in which the tile was created}

\item{tileNum}{The index of the tile as given in nlTileIndex}
}
\value{
A character string filename of the compressed .tgz VIIRS tile
}
\description{
Constructs the filename used to save/access the downloaded VIIRS tile .tgz file
}
\examples{
\dontrun{
Rnightlights:::getNlTileZipLclNameVIIRS("201401", 1)
 #returns "./tiles/VIIRS_2014_01_75N180W.tgz"
 }

}
