% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrynldata.R
\name{deleteNlDataCol}
\alias{deleteNlDataCol}
\title{Delete an aggregate nightlight data column in a country nightlights dataframe}
\usage{
deleteNlDataCol(ctryCode = NULL, admLevel, nlType,
  configName = pkgOptions(paste0("configName_", nlType)),
  multiTileStrategy = pkgOptions("multiTileStrategy"),
  multiTileMergeFun = pkgOptions("multiTileMergeFun"),
  removeGasFlares = pkgOptions("removeGasFlares"), nlPeriod, nlStat,
  gadmVersion = pkgOptions("gadmVersion"),
  gadmPolyType = pkgOptions("gadmPolyType"), custPolyPath = NULL)
}
\arguments{
\item{ctryCode}{country with the  data column to remove}

\item{admLevel}{admLevel to process}

\item{nlType}{the type of nightlight data}

\item{configName}{character the type of raster being processed}

\item{multiTileStrategy}{character How to handle multiple tiles per nlPeriod}

\item{multiTileMergeFun}{character The function to use to merge tiles}

\item{removeGasFlares}{logical Whether to perform gas flare removal pre-processing}

\item{nlPeriod}{the nlPeriod that the dataCol belongs to}

\item{nlStat}{the stat which produced the dataCol vector}

\item{gadmVersion}{The GADM version to use}

\item{gadmPolyType}{The format of polygons to download from GADM}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}
}
\description{
Delete an aggregate nightlight data column in a country nightlights dataframe. The number
    of elements in the vector MUST match the number of rows in the country dataframe.
}
\examples{

\dontrun{
ctryNlDataDF <- Rnightlights:::deleteNlDataCol(ctryNlDataDF, 
     "VIIRS.M", "201409", "sum")
     }

\dontrun{
Rnightlights:::deleteNlDataCol(ctryNlDataDF, 
    "OLS.Y", "2012", "mean")
    }

}
