% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{chi_test_cont}
\alias{chi_test_cont}
\title{This function performs a number of chisquare gof tests for continuous data}
\usage{
chi_test_cont(
  x,
  pnull,
  param,
  formula = "Pearson",
  rate = 0,
  nbins = as.integer(c(100, 10)),
  Range = as.numeric(c(-99999, 99999)),
  Minimize = 0L,
  minexpcount = 2
)
}
\arguments{
\item{x}{data set}

\item{pnull}{cdf under the null hypothesis}

\item{param}{starting values of multi-D minimum chi square minimization}

\item{formula}{Formula of chi square to use}

\item{rate}{rate of Poisson if sample size is random}

\item{nbins}{=c(100, 10) number of bins for chisquare tests}

\item{Range}{=(-99999, 99999) limits of possible observations, if any}

\item{Minimize}{Should minimum chi square be found?}

\item{minexpcount}{=2 minimal expected bin count required}
}
\value{
A numeric matrix of test statistics, degrees of freedom and p values
}
\description{
This function performs a number of chisquare gof tests for continuous data
}
\keyword{internal}
