% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivpml.R
\name{ivpml}
\alias{ivpml}
\alias{terms.ivpml}
\alias{model.matrix.ivpml}
\alias{estfun.ivpml}
\alias{bread.ivpml}
\alias{AIC.ivpml}
\alias{BIC.ivpml}
\alias{vcov.ivpml}
\alias{df.residual.ivpml}
\alias{coef.ivpml}
\alias{logLik.ivpml}
\alias{print.ivpml}
\alias{summary.ivpml}
\alias{print.summary.ivpml}
\alias{predict.ivpml}
\title{Estimate Instrumental Variable Probit model by Maximum Likelihood.}
\usage{
ivpml(formula, data, messages = TRUE, ...)

\method{terms}{ivpml}(x, ...)

\method{model.matrix}{ivpml}(object, ...)

\method{estfun}{ivpml}(x, ...)

\method{bread}{ivpml}(x, ...)

\method{AIC}{ivpml}(object, k = 2, ...)

\method{BIC}{ivpml}(object, ...)

\method{vcov}{ivpml}(object, ...)

\method{df.residual}{ivpml}(object, ...)

\method{coef}{ivpml}(object, ...)

\method{logLik}{ivpml}(object, ...)

\method{print}{ivpml}(x, ...)

\method{summary}{ivpml}(object, eigentol = 1e-12, ...)

\method{print}{summary.ivpml}(x, digits = max(3, getOption("digits") - 2), ...)

\method{predict}{ivpml}(object, newdata = NULL, type = c("xb", "pr", "stdp"), asf = TRUE, ...)
}
\arguments{
\item{formula}{a symbolic description of the model of the form \code{y ~ x | z} where \code{y} is the binary dependent variable, \code{x} includes the exogenous and the endogenous continuous variable, and \code{z} is the complete set of instruments.}

\item{data}{the data of class \code{data.frame}.}

\item{messages}{if \code{TRUE}, then additional messages for the estimation procedure are displayed.}

\item{...}{arguments passed to \code{maxLik}.}

\item{x, object}{an object of class \code{ivpml}.}

\item{k}{a numeric value, use as penalty coefficient for number of parameters in the fitted model.}

\item{eigentol}{the standard errors are only calculated if the ratio of the smallest and largest eigenvalue of the Hessian matrix is less than \code{eigentol}.  Otherwise the Hessian is treated as singular.}

\item{digits}{the number of digits.}

\item{newdata}{optionally, a data frame in which to look for variables with which to predict.}

\item{type}{the type of prediction required. The default, \code{type = xb}, is on the linear prediction. If \code{type = pr}, the predicted probabilities of a positive outcome is returned. Finally, if \code{type = stdp} the standard errors of the linear predictions for each individual is returned.}

\item{asf}{if \code{TRUE}, the average structural function is used. This option is not allowed with \code{xb} or \code{stdp}.}
}
\description{
Estimation of Probit model with one endogenous and continuous variable by Maximum Likelihood.
}
\author{
Mauricio Sarrias.
}
