% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.input.R
\name{validate.geneset}
\alias{validate.geneset}
\title{Validate Geneset}
\usage{
validate.geneset(data, geneset, highlight.1, highlight.2)
}
\arguments{
\item{data}{summary statistics table or a list contain multiple summary statistics tables from limma or DEseq2, where each row is a gene.}

\item{geneset}{a summary statistic table contain the genes want to be highlighted, the gene name format (in row names)
needs to be consistent to the main summary statistics table). For example, this summary statistics
table coulb be the output summary statistics table from Disease vs Healthy comparison (Only contain
the subsetted significant genes want to be highlighted).}

\item{highlight.1}{genes want to be highlighted, in the format of a vector consists of gene names. The gene name format
needs to be consistent to the main summary statistics table.}

\item{highlight.2}{genes want to be highlighted, in the format of a vector consists of gene names. The gene name format
needs to be consistent to the main summary statistics table.}
}
\value{
A character value indicating if the geneset was passed as a
dataframe (\code{df}) or two vectors (\code{vec}), if a list is input
the number of returned values equal the length of the list
}
\description{
This function ensures that the input geneset to check.cutoff
is formatted properly and in a usable form.
}
\details{
The function ensures that only a dataframe or vectors are supplied,
that at least one or the other is supplied, and that their formatting
is correct if supplied. It also checks if any of the genes overlap
with the genes in the datanames.
}
\references{
Xingpeng Li, Tatiana Gelaf Romer & Siddhartha Pachhai RVA - RNAseq Visualization Automation tool.
}
