% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Percentil.Arrow.plot.r
\name{Percentil.Arrow.plot}
\alias{Percentil.Arrow.plot}
\title{Percentil.Arrow.plot}
\usage{
Percentil.Arrow.plot(
  quantiles.sym,
  concept.names,
  var.names,
  Title,
  axes.x.label,
  axes.y.label,
  label.name
)
}
\arguments{
\item{quantiles.sym}{Matrix of Quantiles}

\item{concept.names}{Concept Names}

\item{var.names}{Variables to plot the arrows}

\item{Title}{Plot title}

\item{axes.x.label}{Label of axis X}

\item{axes.y.label}{Label of axis Y}

\item{label.name}{Label}
}
\value{
Arrow Plot
}
\description{
Percentil.Arrow.plot
}
\examples{
\dontrun{
data("hardwoodBrito")
Hardwood.histogram<-hardwoodBrito
Hardwood.cols<-colnames(Hardwood.histogram)
Hardwood.names<-row.names(Hardwood.histogram)
 M<-length(Hardwood.cols)
 N<-length(Hardwood.names)
 BIN.Matrix<-matrix(rep(3,N*M),nrow = N)
pca.hist<-sym.histogram.pca(Hardwood.histogram,BIN.Matrix)
 M<-length(Hardwood.cols)
 N<-length(Hardwood.names)
 BIN.Matrix<-matrix(rep(3,N*M),nrow = N)
label.name<-"Hard Wood"
Title<-"First Principal Plane"
axes.x.label<- "First Principal Component (84.83\%)"
axes.y.label<- "Second Principal Component (9.70\%)"
concept.names<-c("ACER")
var.names<-c("PC.1","PC.2")
quantile.ACER.plot<-Percentil.Arrow.plot(Hardwood.quantiles.PCA,
                                        concept.names,
                                        var.names,
                                        Title,
                                        axes.x.label,
                                        axes.y.label,
                                        label.name
                                        )
quantile.ACER.plot
}
}
\author{
Jorge Arce Garro
}
