% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reveal.model.designs.r
\name{reveal.model.designs}
\alias{reveal.model.designs}
\title{Reveal model designs used in lm.rrpp fit}
\usage{
reveal.model.designs(fit)
}
\arguments{
\item{fit}{A linear model fit from \code{\link{lm.rrpp}}.}
}
\description{
Function returns every full and reduced model for model terms used in lm.rrpp fits.  This function is useful for revealing 
the null and full model that would be used in the pairwise function, if a specific null model is not declared as an argument
(fit.null in the \code{\link{pairwise}} function).
It also helps to demonstrate how sums of squares and cross-products (SSCP) are calculated in lm.rrpp permutations (iterations),
from the difference between fitted values for null and full designs.
}
\examples{

data(Pupfish)
fit1 <- lm.rrpp(coords~ Pop*Sex, data = Pupfish, 
SS.type = "I", print.progress = FALSE, iter = 0)
fit2 <- lm.rrpp(coords~ Pop*Sex, data = Pupfish, 
SS.type = "II", print.progress = FALSE, iter = 0)
fit3 <- lm.rrpp(coords~ Pop*Sex, data = Pupfish, 
SS.type = "III", print.progress = FALSE, iter = 0)

reveal.model.designs(fit1)
reveal.model.designs(fit2)
reveal.model.designs(fit3)

}
\author{
Michael Collyer
}
\keyword{analysis}
