% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgb.R
\name{channels}
\alias{channels}
\title{Extract channels from RGB data}
\usage{
channels(array, channels = c("red", "green", "blue", "alpha"), raw = FALSE)
}
\arguments{
\item{array}{An image, an \code{rgbArray}, or another array that can be
converted to the latter.}

\item{channels}{A character vector of channels to extract.}

\item{raw}{Boolean value: if \code{TRUE}, return a raw array, which is the
most compact representation; otherwise return an integer array.}
}
\value{
A raw-mode or integer-mode array with one more dimension than the
  first argument, corresponding to channels.
}
\description{
Extract one or more channels from an RGB data array that was obtained from
an RGB NIfTI image or created by the \code{\link{rgbArray}} function. The
result is more amenable to numeric manipulation.
}
\author{
Jon Clayden <code@clayden.org>
}
