% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pMC.R
\name{pMC}
\alias{pMC}
\title{Probability (percentile) for the Monte Carlo Sampling Distribution of a nonlinear function of coefficients estimates}
\usage{
pMC(q, mu, Sigma, quant, lower.tail = TRUE, n.mc = 1e+06, ...)
}
\arguments{
\item{q}{quantile}

\item{mu}{a \link{vector} of means (e.g., coefficient estimates) for the normal random variables. A user can assign a name to each mean value, e.g., \code{mu=c(b1=.1,b2=3)}; otherwise, the coefficient names are assigned automatically as follows: \code{b1,b2,...}.}

\item{Sigma}{either a covariance matrix or a \link{vector} that stacks all the columns of the lower triangle variance--covariance matrix one underneath the other.}

\item{quant}{quantity of interest, which is a nonlinear/linear function of the model parameters. Argument \code{quant} is a \link{formula} that \strong{must} start with the symbol "tilde" (\code{~}): e.g., \code{~b1*b2*b3*b4}. The names of coefficients must conform to the names provided in the argument \code{mu} or to the default names, i.e., \code{b1,b2,...}.}

\item{lower.tail}{logical; if \code{TRUE} (default), the probability is \eqn{P[quant < q]}; otherwise, \eqn{P[quant > q]}}

\item{n.mc}{Monte Carlo sample size. The default sample size is 1e+6.}

\item{...}{additional arguments.}
}
\value{
scalar probability value.
}
\description{
This function returns a probability corresponding to the quantile \code{q}.
}
\examples{
pMC(.2,mu=c(b1=1,b2=.7,b3=.6, b4= .45), Sigma=c(.05,0,0,0,.05,0,0,.03,0,.03),
quant=~b1*b2*b3*b4)
}
\references{
Tofighi, D. and MacKinnon, D. P. (2011). RMediation: An R package for mediation analysis confidence intervals. \emph{Behavior Research Methods}, \bold{43}, 692--700. doi:10.3758/s13428-011-0076-x
}
\seealso{
\code{\link{medci}} \code{\link{RMediation-package}}
}
\author{
Davood Tofighi \email{dtofighi@gmail.com}
}
\keyword{distribution}
\keyword{regression}
