% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbco.R
\name{mbco}
\alias{mbco}
\title{Model-based Constrained Optimization (MBCO) Chi-squared Test}
\usage{
mbco(
  h0 = NULL,
  h1 = NULL,
  R = 10L,
  type = "asymp",
  alpha = 0.05,
  checkHess = "No",
  checkSE = "No",
  optim = "SLSQP",
  precision = 1e-09
)
}
\arguments{
\item{h0}{An \code{OpenMx} model estimated under a null hypothesis, which is a more constrained model}

\item{h1}{An \code{OpenMx} model estimated under an alternative hypothesis, which is a less constrained model. This is usually a model hypothesized by a researcher.}

\item{R}{The number of bootstrap draws.}

\item{type}{If 'asymp' (default), the asymptotic MBCO chi-squares test comparing fit of h0 and h1. If 'parametric', the parametric bootstrap MBCO chi-squared test is computed. If 'semi', the semi-parametric MBCO chi-squared is computed.}

\item{alpha}{Significance level with the default value of .05}

\item{checkHess}{If 'No' (default), the Hessian matrix would not be calculated.}

\item{checkSE}{if 'No' (default), the standard errors would not be calculated.}

\item{optim}{Choose optimizer available in OpenMx. The default optimizer is "SLSQP". Other optimizer choices are available. See \link{mxOption} for more details.}

\item{precision}{Functional precision. The default value is set to 1e-9. See \link{mxOption} for more details.}
}
\value{
A \link{list} that contains \item{chisq}{asymptotic chi-squared test statistic value} \item{\code{df}}{chi-squared df} \item{p}{chi-squared p-value computed based on the method specified by the argument \code{type}}
}
\description{
This function computes asymptotic MBCO chi-squared test for a smooth function of model parameters including a function of indirect effects.
}
\examples{
data(memory_exp)
memory_exp$x <- as.numeric(memory_exp$x)-1 # manually creating dummy codes
endVar <- c('x', 'repetition', 'imagery', 'recall')
manifests <- c('x', 'repetition', 'imagery', 'recall')
full_model <- mxModel(
 "memory_example",
 type = "RAM",
 manifestVars = manifests,
 mxPath(
   from = "x",
   to = endVar,
   arrows = 1,
   free = TRUE,
   values = .2,
   labels = c("a1", "a2", "cp")
 ),
 mxPath(
   from = 'repetition',
  to = 'recall',
  arrows = 1,
   free = TRUE,
   values = .2,
   labels = 'b1'
 ),
 mxPath(
   from = 'imagery',
 to = 'recall',
 arrows = 1,
 free = TRUE,
 values = .2,
 labels = "b2"
),
mxPath(
 from = manifests,
 arrows = 2,
 free = TRUE,
 values = .8
),
mxPath(
 from = "one",
 to = endVar,
 arrows = 1,
 free = TRUE,
 values = .1
),
mxAlgebra(a1 * b1, name = "ind1"),
mxAlgebra(a2 * b2, name = "ind2"),
mxCI("ind1", type = "both"),
mxCI("ind2", type = "both"),
mxData(observed = memory_exp, type = "raw")
)
## Reduced  Model for indirect effect: a1*b1
null_model1 <- mxModel(
model= full_model,
name = "Null Model 1",
mxConstraint(ind1 == 0, name = "ind1_eq0_constr")
)
full_model <- mxTryHard(full_model, checkHess=FALSE, silent = TRUE )
null_model1 <- mxTryHard(null_model1, checkHess=FALSE, silent = TRUE )
mbco(null_model1,full_model)
}
\references{
Tofighi, D., & Kelley, K. (2020). Indirect effects in sequential mediation models: Evaluating methods for hypothesis testing and confidence interval formation. \emph{Multivariate Behavioral Research}, \bold{55}, 188–210. \doi{https://doi.org/10.1080/00273171.2019.1618545}

Tofighi, D. (2020). Bootstrap Model-Based Constrained Optimization Tests of Indirect Effects. \emph{Frontiers in Psychology}, \bold{10}, 2989. \doi{https://doi.org/10.3389/fpsyg.2019.02989}
}
\author{
Davood Tofighi \email{dtofighi@gmail.com}
}
