% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recommenders.R
\name{MOA_recommender}
\alias{MOA_recommender}
\title{Create a MOA recommendation engine}
\usage{
MOA_recommender(model, control = NULL, ...)
}
\arguments{
\item{model}{character string with a model.
E.g. BRISMFPredictor, BaselinePredictor
The list of known models can be obtained by typing RMOA:::.moaknownmodels. 
See the examples and \code{\link{MOAoptions}}.}

\item{control}{an object of class \code{MOAmodelOptions} as obtained by calling \code{\link{MOAoptions}}}

\item{...}{options of parameters passed on to \code{\link{MOAoptions}}, in case \code{control} is left to NULL. 
Ignored if \code{control} is supplied}
}
\value{
An object of class \code{MOA_recommender}
}
\description{
Create a MOA recommendation engine
}
\examples{
RMOA:::.moaknownmodels
ctrl <- MOAoptions(model = "BRISMFPredictor", features = 10, lRate=0.002)
brism <- MOA_recommender(model = "BRISMFPredictor", control=ctrl)
brism
MOAoptions(model = "BaselinePredictor")
baseline <- MOA_recommender(model = "BaselinePredictor")
baseline
}
\seealso{
\code{\link{MOAoptions}}
}
