% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climacell_temperature.R
\name{climacell_temperature}
\alias{climacell_temperature}
\title{Temperature Readings from Climacell}
\usage{
climacell_temperature(
  api_key,
  lat,
  long,
  timestep,
  start_time = NULL,
  end_time = NULL
)
}
\arguments{
\item{api_key}{character string representing the private API key. Provided by user or loaded automatically from environment variable (environment variable must be called "CLIMACELL_API")}

\item{lat}{a numeric value (or a string that can be coerced to numeric) representing the latitude of the location}

\item{long}{a numeric value (or a string that can be coerced to numeric) representing the longitude of the location}

\item{timestep}{a 'step' value for the time. Choose one of the following valid values: c('1d', '1h', '30m','15m','5m','1m','current')}

\item{start_time}{the start date and time of the query in \href{https://en.wikipedia.org/wiki/ISO_8601}{ISO8601} format. This value cannot be more than 6 hours prior to the current local time. OPTIONAL if timestep is 'current'.}

\item{end_time}{the end date and time of the query in \href{https://en.wikipedia.org/wiki/ISO_8601}{ISO8601} format. The maximum end date/time depends on the timestep value chosen (see vignette for more information). OPTIONAL if timestep is 'current' or you wish to get the maximum results possible.}
}
\value{
a tibble
}
\description{
This function will make a call to the Climacell API and retrieve temperature related variables.
}
\details{
\code{climacell_temperature} returns a tibble that consists of temperature related variables (returned values are in metric units) using the Climacell API. These variables consist of temperature, a "feels like" temperature, dewpoint, and humidity.
}
\examples{
\dontrun{
climacell_temperature(
  api_key = Sys.getenv('CLIMACELL_API'),
  lat = 0,
  long = 0,
  timestep = 'current')
}
}
