% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_brar_unknown_var.r
\name{sim_brar_unknown_var}
\alias{sim_brar_unknown_var}
\title{Simulate a Trial Using Bayesian Response-Adaptive Randomization with a Control Group for Continuous Endpoint with Unknown Variances}
\usage{
sim_brar_unknown_var(
  Pats,
  nMax,
  TimeToOutcome,
  enrollrate,
  N1,
  armn,
  au,
  N2,
  tp,
  armlabel,
  blocksize,
  mean = 0,
  sd = 1,
  minstart,
  deltaa,
  tpp,
  deltaa1,
  V01,
  a01,
  b01,
  m01,
  V02 = V01,
  V03 = V01,
  V04 = V01,
  V05 = V01,
  a02 = a01,
  a03 = a01,
  a04 = a01,
  a05 = a01,
  b02 = b01,
  b03 = b01,
  b04 = b01,
  b05 = b01,
  m02 = m01,
  m03 = m01,
  m04 = m01,
  m05 = m01,
  side,
  ...
)
}
\arguments{
\item{Pats}{the number of patients accrued within a certain time frame indicates the
count of individuals who have been affected by the disease during that specific period,
for example, a month or a day. If this number is 10, it represents that
10 people have got the disease within the specified time frame.}

\item{nMax}{the assumed maximum accrued number of patients with the disease in the population, this number
should be chosen carefully to ensure a sufficient number of patients are simulated,
especially when considering the delay mechanism.}

\item{TimeToOutcome}{the distribution of delayed response times or a fixed delay time for responses.
The delayed time could be a month, a week or any other time frame. When the unit changes,
the number of TimeToOutcome should also change. It can be in the format
of expression(rnorm( length( vStartTime ),30, 3)), representing delayed responses
with a normal distribution, where the mean is 30 days and the standard deviation is 3 days.}

\item{enrollrate}{probability that patients in the population can enroll in the trial.
This parameter is related to the number of people who have been affected by the disease in the population,
following an exponential distribution.}

\item{N1}{number of participants with equal randomization in the 'initialization' period.
Recommend using 10 percent of the total sample size.}

\item{armn}{number of total arms in the trial.}

\item{au}{a vector of cut-off values in the final selection at the end of the trial,
with a length equal to the number of arms minus 1.}

\item{N2}{maximal sample size for the trial.}

\item{tp}{tuning parameter. Some commonly used numbers are 0.5, 1 and n/2N.}

\item{armlabel}{a vector of treatment labels with an example of c(1, 2), where 1 and 2 describe
how each arm is labeled in a two-armed trial.}

\item{blocksize}{size of block used for equal randomization regarding participants in the 'initialization' period.
Recommend to be an even multiple of the number of total arms.}

\item{mean}{a vector of means in hypotheses, for example, as c(10,10) where 10 stands for the mean
in both groups. Another example is c(10,12) where 10 and 12 stand for the mean
for the control and the other treatment group, respectively.}

\item{sd}{a vector of standard deviations in hypotheses, for example, as c(2,2) where 2 stands for the standard deviation
in both groups. Another example is c(1,2) where 1 and 2 stand for the standard deviation
for the control and the other treatment group, respectively.}

\item{minstart}{a specified number of participants when one starts to check decision rules.}

\item{deltaa}{a vector of minimal effect expected to be observed for early futility stopping in
each arm is approximately \eqn{1\%}. The length of this parameter is \code{armn}-1.}

\item{tpp}{indicator of \code{tp} equals to n/2N. When \code{tp} is n/2N, \code{tpp} should be assigned 1. Default value is set to 0.}

\item{deltaa1}{a vector of pre-specified minimal effect size expected to be observed at the final stage
for each arm. The length of this parameter is \code{armn}-1.}

\item{V01, a01, b01, m01}{prior parameters m, V, a, b in \eqn{NIG(V,m,a,b)} of arm 1 in the trial, which stands for the control.}

\item{V02, a02, b02, m02}{prior parameters m, V, a, b in \eqn{NIG(V,m,a,b)} of arm 2 in the trial. Default value is set to \code{V01},
\code{a01}, \code{b01} and \code{m01}.}

\item{V03, a03, b03, m03}{prior parameters m, V, a, b in \eqn{NIG(V,m,a,b)} of arm 3 in the trial. Default value is set to \code{V01},
\code{a01}, \code{b01} and \code{m01}.}

\item{V04, a04, b04, m04}{prior parameters m, V, a, b in \eqn{NIG(V,m,a,b)} of arm 4 in the trial. Default value is set to \code{V01},
\code{a01}, \code{b01} and \code{m01}.}

\item{V05, a05, b05, m05}{prior parameters m, V, a, b in \eqn{NIG(V,m,a,b)} of arm 5 in the trial. Default value is set to \code{V01},
\code{a01}, \code{b01} and \code{m01}.}

\item{side}{direction of a one-sided test, with values 'upper' or 'lower'.}

\item{...}{additional arguments to be passed to \code{\link[stats]{integrate}} (such as rel.tol) from this function.}
}
\value{
\code{sim_brar_unknown_var} returns an object of class "brar". An object of class "brar" is a list containing 
final decision, test statistics, the simulated data set and participants accrued for each arm 
at the time of termination of that group in one trial.
The simulated data set includes 5 columns: participant ID number, enrollment time, observed time of results,
allocated arm, and participants' results. In the final decision, 'Superiorityfinal' refers to the selected arm, 
while 'Not Selected' indicates the arm stopped due to futility, and 'Control Selected' denotes the control arm chosen 
because other arms did not meet futility criteria before the final stage or were not deemed effective at the final stage. 
Note that before final stage of the trial, test statistics is calculated from \code{deltaa}, and test statistics is
calculated from \code{deltaa1} at the final stage.
}
\description{
\code{sim_brar_unknown_var} simulate a trial with two to five arms using Bayesian Response-Adaptive 
Randomization with a control group for continuous outcomes with unknown variances. The conjugate prior distributions
follow Normal-Inverse-Gamma (NIG) (\eqn{(\mu,\sigma^2) \sim NIG(mean=m,variance=V \times \sigma^2,shape=a,rate=b)}) 
distributions and can be specified individually for each arm.
}
\details{
This function generates a designed trial using Bayesian response-adaptive randomization with
a control group under no delay and delayed scenarios for continuous outcomes with unknown variances. 
The function can handle trials with up to 5 arms. This function uses the formula
\eqn{\frac{Pr(\mu_k=max\{\mu_1,...,\mu_K\})^{tp}} {\sum_{k=1}^{K}{Pr(\mu_k=max\{\mu_1,...,\mu_K\})^{tp}}}} with \code{side} equals to 'upper',
and \eqn{\frac{Pr(\mu_k=min\{\mu_1,...,\mu_K\})^{tp}} {\sum_{k=1}^{K}{Pr(\mu_k=min\{\mu_1,...,\mu_K\}){tp}}}} 
with \code{side} equals to 'lower', utilizing available data at each step.
Considering the delay mechanism, \code{Pats} (the number of patients accrued within a certain time frame),
\code{nMax} (the assumed maximum accrued number of patients with the disease in the population) and 
\code{TimeToOutcome} (the distribution of delayed response times or a fixed delay time for responses) 
are parameters in the functions adapted from \url{https://github.com/kwathen/IntroBayesianSimulation}.
Refer to the website for more details.
}
\examples{
#sim_brar_unknown_var with delayed responses follow a normal distribution with
#a mean of 30 days and a standard deviation of 3 days under the null hypothesis,
#where mean=c(9.19/100,8.74/100,8.74/100), sd=c(0.009,0.009,0.009), tp=1 and 
#the minimal effect size is 0.
sim_brar_unknown_var(Pats=10,nMax=50000,TimeToOutcome=expression(rnorm(
length(vStartTime ),30,3)),enrollrate=0.1, N1=48,armn=3,au=c(0.85,0.85),
N2=480,tp=1,armlabel=c(1, 2,3),blocksize=6,mean=c(9.19/100,8.74/100,8.74/100),
sd=c(0.009,0.009,0.009), minstart=48,deltaa=c(-0.000325,-0.000325),
tpp=0,deltaa1=c(0,0),V01=1/2,a01=0.3,m01=9/100,b01=0.00001,side='lower')
}
\references{
\insertRef{Kevin2007}{RARtrials}
}
