% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConsensusAlign.R
\name{ConsensusAlign}
\alias{ConsensusAlign}
\title{Takes a vector of paths to input files and aligns common metabolites into a final table.  Will also identify metabolites if a reference library is provided}
\usage{
ConsensusAlign(inputFileList, RT1_Standards = NULL, RT2_Standards = NULL,
  seedFile = 1, RT1Penalty = 1, RT2Penalty = 10,
  autoTuneMatchStringency = TRUE, similarityCutoff = 90,
  disimilarityCutoff = similarityCutoff - 90, numCores = 1,
  commonIons = c(), missingValueLimit = 0.75,
  missingPeakFinderSimilarityLax = 0.85, quantMethod = "T",
  standardLibrary = NULL)
}
\arguments{
\item{inputFileList}{Vector of file paths to align}

\item{RT1_Standards}{Vector of standard names used to adjust first retention time. All names must be found in input files. Defaults to NULL.}

\item{RT2_Standards}{Vector of standard names used to adjust second retention time. All names must be found in input files. Defaults to NULL.}

\item{seedFile}{File number in inputFileList to initialize alignment. Can also input a vector of different seed files (3 is usually sufficient) to prevent bias from seed file.  Defaults to 1.}

\item{RT1Penalty}{Penalty used for first retention time errors.  Defaults to 1.}

\item{RT2Penalty}{Penalty used for first retention time errors.  Defaults to 10.}

\item{autoTuneMatchStringency}{Will automatically find optimal match threshold. If TRUE, will ignore similarityCutoff. Defaults to TRUE.}

\item{similarityCutoff}{Adjusts peak similarity threshold required for alignment. Adjust in concordance with RT1 and RT2 penalties. Will be ignored if autoTuneMatchStrigency is TRUE. Defaults to 90.}

\item{disimilarityCutoff}{Defaults to similarityCutoff-90. Sets the threshold for including a new peak in the alignment table to ensure new metabolites aren't just below alignment thresholds}

\item{numCores}{Number of cores used to parallelize alignment. See parallel package. Defaults to 4.}

\item{commonIons}{Provide a vector of ions to ignore from the FindProblemIons function. Defaults to empty vector.}

\item{missingValueLimit}{Maximum fraction (Numeric between 0 and 1) of missing values acceptable for retaining a metabolite in the final alignment table. Defaults to 0.25.}

\item{missingPeakFinderSimilarityLax}{Fraction of Similarity Cutoff to use to find missing alignments just below threshold. Set to 1 to prevent searching for missing peaks. Defaults to 0.85.}

\item{quantMethod}{Set to U, A, or T to indicate if unique mass (U), appexing masses (A), or total ion chormatograph (T) was used to quantify peak areas. Defaults to T.  If "T" or "A", peaks meeting similarity thresholds will simply be summed. If "U", peaks with the same unique mass with be summed and a proportional conversion will be used before combining peaks with different unique masses.}

\item{standardLibrary}{Defaults to NULL. Provide standard library generated from MakeReference function to ID metabolites with retention index.}
}
\value{
A list with three items: AlignmentMatix - A dataframe with peak areas for all metabolites matched in sufficient number of samples. MetaboliteInfo - An info file with RT, spectra, and metabolite ID info for each metabolite in the AlignmentMatrix. UnmatchedQuantMasses- Info on metabolites combined that had different unique masses (if quantMethod="U") or greater than 50% different apexing masses (if quantMethod="A")
}
\description{
Takes a vector of paths to input files and aligns common metabolites into a final table.  Will also identify metabolites if a reference library is provided
}
\examples{
ConsensusAlign(c(system.file("extdata", "SampleA.txt", package="R2DGC"),
    system.file("extdata", "SampleB.txt", package="R2DGC")), RT1_Standards= c())
}
