\name{CopulaAC}
\alias{dcopula.AC}
\alias{dcopula.clayton}
\alias{dcopula.gumbel}
\alias{rAC}
\alias{rACp}
\alias{rcopula.gumbel}
\alias{rcopula.clayton}
\alias{rcopula.frank}
\alias{rstable}
\alias{rFrankMix}
\alias{rBB9Mix}
\alias{rcopula.Gumbel2Gp}
\alias{rcopula.GumbelNested}
\alias{fit.AC}

\title{Archimedean Copulae}

\description{
  Functions for ealuating densities of Archimedean copulae, generating
  random variates and fitting data to AC
}

\usage{
dcopula.AC(u, theta, name = c("clayton", "gumbel"), log = TRUE)
dcopula.clayton(u, theta, log = FALSE)
dcopula.gumbel(u, theta, log = FALSE)
rAC(name = c("clayton", "gumbel", "frank", "BB9", "GIG"), n, d, theta)
rACp(name = c("clayton", "gumbel", "frank", "BB9", "GIG"), n, d, theta, A)
rcopula.gumbel(n, theta, d)
rcopula.clayton(n, theta, d)
rcopula.frank(n, theta, d)
rstable(n, alpha, beta = 1)
rFrankMix(n, theta)
rBB9Mix(n, theta)
rcopula.Gumbel2Gp(n = 1000, gpsizes = c(2, 2), theta = c(2, 3, 5))
rcopula.GumbelNested(n, theta)
fit.AC(Udata, name = c("clayton", "gumbel"), initial = 2, ...)
}

\arguments{
  \item{A}{\code{matrix}, dimension \eqn{d \times p} containing asymmetry
  parameters. Rowsums must be equal to one.}
  \item{alpha}{\code{numeric}, parameter \eqn{0 < \alpha \le 2}, but \eqn{\alpha
      \ne 1}.}
  \item{beta}{\code{numeric}, parameter \eqn{-1 \le \beta \le 1}.}
  \item{d}{\code{integer}, dimension of copula.}
  \item{gpsizes}{\code{vector}, length of two, containing the group
    sizes.}
  \item{initial}{\code{numeric}, initial value used by \code{fit.AC()} in
    the call to \code{nlminb()}.}
  \item{log}{\code{logical}, whether log density values should be returned}
  \item{n}{\code{integer}, count of random variates.}
  \item{name}{\code{character}, name of copula.}
  \item{theta}{\code{vector}, copula parameter(s).}
  \item{u}{\code{matrix}, dimension \eqn{n \times d}, where d is the
  dimension of the copula and n is the number of vector values at which
  to evaluate density.}
  \item{Udata}{\code{matrix}, pseudo-uniform observations.}
  \item{...}{ellipsis, arguments are passed down to \code{nlminb()}.}
}

\details{
 The function \code{dcopula.AC()} is a generic function, designed such
 that additional copulae, or expressions for densities of
 higher-dimensional copulae may be added. Clayton copula works in any
 dimension at present but Gumbel is only implemented for \eqn{d = 2}{d =
 2}. To extend, one must calculate the d-th derivative of the generator
 inverse and take the logarithm of absolute value; this is the term
 called \code{loggfunc}. In addition, for other copulae, one needs the
 generator \eqn{\phi}{phi} and the log of the negative value of its
 first derivative \code{lnegphidash}.\cr 
 The random variates from \code{rAC()} with arbitrary dimension are
 generated by using the mixture construction of Marshall and Olkin. It
 may be used in place of the other functions \code{rcopula.clayton()},
 \code{rcopula.gumbel()}, and \code{rcopula.frank()}. In addition, it
 allows simulation of BB9 and GIG copulas which don't have individual
 simulation routines.\cr
 For the Clayton and Gumbel copulae, see page 192 and 222--224 in
 QRM. The random variates for the BB9 and Frank copula are obtained from
 a mixing distribution using a Laplace transform method (see page 224 of
 QRM). The function \code{rcopula.Gumbel2Gp()} generates sample from a
 Gumbel copula with two-group structure constructed using three Gumbel
 generators (see pages 222-224 and 227 of QRM). The function
 \code{rcopula.gumbelNested()} generates sample from a d-dimensional
 Gumbel copula with nested structure constructed using
 \eqn{(d-1)}{(d-1)} Gumbel generators.\cr 
 For the random variates of the Stable distribution, a default value
 \eqn{\beta = 1}{beta = 1} is used; combined with a value for
 \eqn{\alpha < 1}{alpha < 1} yields a positive stable distribution,
 which is required for Gumbel copula generation; the case \eqn{\alpha =
 1}{alpha = 1} has not been implemented.   
}

\value{
  vector or matrix in case of the density and random-generator related
  functions and a list object for the fitting function.
}

\seealso{
  \code{\link[stats]{nlminb}}
}

\examples{
## Gumbel
r1 <- rAC("gumbel", n = 50, d = 7, theta = 3)
head(r1)
## Weighted Gumbel
alpha <- c(0.95,0.7)
wtmatrix <- cbind(alpha, 1 - alpha)
r2 <- rACp(name = "gumbel", n = 1000, d = 2, theta = c(4, 1),
           A = wtmatrix)
head(r2)
## Gumbel with two-group structure
r3 <- rcopula.Gumbel2Gp(n = 3000, gpsizes = c(3, 4),
                        theta = c(2, 3, 5)) 
pairs(r3)
## Nested Gumbel
r4 <- rcopula.GumbelNested(n=3000,theta=1:6) 
pairs(r4) 
## Frank
r5 <- rcopula.frank(1000, 2, 4) 
pairs(r5)
## Fitting of Gumbel and Clayton
data(smi)
data(ftse100)
s1 <- window(ftse100, "1990-11-09", "2004-03-25")
s1a <- alignDailySeries(s1)
s2a <- alignDailySeries(smi)
idx <- merge(s1a, s2a)
r <-returns(idx)
rp <- series(window(r, "1994-01-01", "2003-12-31"))
rp <- rp[(rp[, 1] != 0) & (rp[, 2] !=0), ]
Udata <- apply(rp, 2, edf, adjust = 1)
mod.gumbel <- fit.AC(Udata, "gumbel")
mod.clayton <- fit.AC(Udata, "clayton")
mod.clayton
}

\keyword{distribution}

