% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.cmprsk}
\alias{summary.cmprsk}
\title{Summary of a Competing Risks Regression Model}
\usage{
\S3method{summary}{cmprsk}(object, \dots)
}
\arguments{
\item{object}{A model fit by \code{\link[QHScrnomo]{crr.fit}}}

\item{...}{Other arguments for \code{\link[rms]{summary.rms}}}
}
\value{
A \code{\link[rms]{summary.rms}} matrix
}
\description{
Uses the \code{\link[rms]{summary.rms}} method to construct a summary for the competing risks regression model fit from \code{\link[QHScrnomo]{crr.fit}}.
}
\note{
This function requires that the \code{\link{rms}} package is attached
}
\examples{
dd <- datadist(prostate.dat)
options(datadist = "dd")
prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
           BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
           RACE_AA, data = prostate.dat,
           x = TRUE, y = TRUE, surv = TRUE,time.inc = 144)
prostate.crr <- crr.fit(prostate.f, cencode = 0, failcode = 1)
summary(prostate.crr)

}
\seealso{
\code{\link[QHScrnomo]{crr.fit}} \code{\link[rms]{summary.rms}}
}
\author{
Changhong Yu. Department of
Quantitative Health Sciences, Cleveland Clinic
}
