% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_compounds.R
\name{get_compounds}
\alias{get_compounds}
\title{Retrieve Compounds from PubChem}
\usage{
get_compounds(
  identifier,
  namespace = "cid",
  operation = NULL,
  searchtype = NULL,
  options = NULL
)
}
\arguments{
\item{identifier}{A vector of positive integers (e.g., cid, sid, aid) or identifier strings (source, inchikey, formula).
In some cases, a single identifier string (e.g., name, smiles, xref; inchi, sdf by POST only) is sufficient.
**Note**: \code{identifier} must be provided; it cannot be \code{NULL}.}

\item{namespace}{A character string specifying the namespace of the identifier.

                 Possible values include:

                 - \code{cid}: PubChem Compound Identifier (default)

                 - \code{name}: Chemical name

                 - \code{smiles}: SMILES string

                 - \code{inchi}: InChI string

                 - \code{inchikey}: InChIKey

                 - \code{formula}: Molecular formula

                 For more details, see the \href{https://pubchem.ncbi.nlm.nih.gov/docs/pug-rest#section=Input}{Input} section of the PUG REST API.}

\item{operation}{A character string specifying the operation to perform.

                 Possible values include:

                 - \code{synonyms}: Retrieve synonyms for the compounds.

                 - \code{description}: Retrieve compound descriptions.

                 - \code{sids}: Retrieve Substance IDs related to the compounds.

                 - \code{aids}: Retrieve Assay IDs related to the compounds.

                 - \code{classification}: Retrieve compound classification.

                 - \code{cids}: Retrieve Compound IDs (used when the input is not CID).

                 If \code{NULL} (default), the basic compound record is retrieved.

                 For a full list of operations, see the \href{https://pubchem.ncbi.nlm.nih.gov/docs/pug-rest#section=Operation}{Operations} section of the PUG REST API.}

\item{searchtype}{An optional character string specifying the search type.

                  Possible values include:

                  - \code{similarity}

                  - \code{substructure}

                  - \code{superstructure}

                  - \code{identity}

                  If \code{NULL} (default), no search type is specified.

                 For more details, see the \href{https://pubchem.ncbi.nlm.nih.gov/docs/pug-rest#section=Input}{Input} section of the PUG REST API.}

\item{options}{A list of additional options for the request.

               Available options depend on the specific request and the API.

               Examples include:

               - For similarity searches: \code{list(Threshold = 95)}

               - For substructure searches: \code{list(MaxRecords = 100)}

               If \code{NULL} (default), no additional options are included.

               For more details, see the \href{https://pubchem.ncbi.nlm.nih.gov/docs/pug-rest#section=Structure-Search-Operations}{Structure Search Operations} section of the PUG REST API.}
}
\value{
An object of class 'PubChemInstanceList' and 'PC_Compounds' containing compound information from the PubChem database.
}
\description{
This function sends a request to the PubChem database to retrieve compound data based on specified parameters.
}
\details{
For more detailed information, please refer to the
\href{https://pubchem.ncbi.nlm.nih.gov/docs/pug-rest}{PubChem PUG REST API documentation}.
}
\examples{
compound <- get_compounds(
  identifier = c("aspirin", "ibuprofen", "rstudio"),
  namespace = "name"
)

print(compound)

# Return results for selected compound.
instance(compound, "aspirin")
instance(compound, "rstudio")
# instance(compound, "unknown"). # returns error.

# Extract compound properties for the compound "aspirin".
# Use the 'retrieve()' function to extract specific slots from the compound list.
retrieve(instance(compound, "aspirin"), "props")

}
\seealso{
\link{retrieve}, \link{instance}
}
