% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hearing_specific_committee.R
\name{get_hearing_specific_committee}
\alias{get_hearing_specific_committee}
\title{Get Hearings for a Specific Committee}
\usage{
get_hearing_specific_committee(
  congress,
  chamber,
  committee_id,
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{congress}{114-116}

\item{chamber}{house or senate}

\item{committee_id}{Optional committee abbreviation, for example HSAG. Use the full committees response to find abbreviations.}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent hearings and supports pagination.
}
\description{
To get a list of 20 upcoming Senate or House committee meetings, use the following function. HTTP Request: GET https://api.propublica.org/congress/v1/{congress}/{chamber}/committees/{committee-id}/hearings.json
}
\examples{
\donttest{
get_hearing_specific_committee(115, 'house', 'HSRU')
get_hearing_specific_committee(115, 'house', 
lists_of_committees(115, "senate")$results[[1]]$committees[[1]]$id)
}
}
