/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.loader;

import org.openfast.Global;
import org.openfast.QName;
import org.openfast.ScalarValue;
import org.openfast.template.Field;
import org.openfast.template.Scalar;
import org.openfast.template.Sequence;
import org.openfast.template.loader.AbstractFieldParser;
import org.openfast.template.loader.GroupParser;
import org.openfast.template.loader.ParsingContext;
import org.openfast.template.loader.ScalarParser;
import org.openfast.template.operator.Operator;
import org.openfast.template.type.Type;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SequenceParser
extends AbstractFieldParser {
    private ScalarParser sequenceLengthParser = new ScalarParser("length"){

        protected Type getType(Element fieldNode, ParsingContext context) {
            return Type.U32;
        }

        protected QName getName(Element fieldNode, ParsingContext context) {
            if (context.getName() == null) {
                return Global.createImplicitName(context.getParent().getName());
            }
            return context.getName();
        }
    };

    public SequenceParser() {
        super("sequence");
    }

    protected Field parse(Element sequenceElement, boolean optional, ParsingContext context) {
        Sequence sequence = new Sequence(context.getName(), this.parseSequenceLengthField(context.getName(), sequenceElement, optional, context), GroupParser.parseFields(sequenceElement, context), optional);
        GroupParser.parseMore(sequenceElement, sequence.getGroup(), context);
        return sequence;
    }

    private Scalar parseSequenceLengthField(QName name, Element sequence, boolean optional, ParsingContext parent) {
        NodeList lengthElements = sequence.getElementsByTagName("length");
        if (lengthElements.getLength() == 0) {
            Scalar implicitLength = new Scalar(Global.createImplicitName(name), Type.U32, Operator.NONE, ScalarValue.UNDEFINED, optional);
            implicitLength.setDictionary(parent.getDictionary());
            return implicitLength;
        }
        Element length = (Element)lengthElements.item(0);
        ParsingContext context = new ParsingContext(length, parent);
        return (Scalar)this.sequenceLengthParser.parse(length, optional, context);
    }
}

