/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.scp10;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.openfast.Global;
import org.openfast.Message;
import org.openfast.MessageOutputStream;
import org.openfast.error.ErrorHandler;
import org.openfast.examples.producer.XmlCompressedMessageConverter;
import org.openfast.session.Endpoint;
import org.openfast.session.FastClient;
import org.openfast.session.FastConnectionException;
import org.openfast.session.MessageListener;
import org.openfast.session.Session;
import org.openfast.session.SessionConstants;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.loader.XMLMessageTemplateLoader;

public class ScpMessageProducer
implements MessageListener {
    private final Endpoint endpoint;
    private final TemplateRegistry templateRegistry;
    private String clientName = "LTG";

    public ScpMessageProducer(Endpoint endpoint, File templatesFile) {
        Global.setErrorHandler(ErrorHandler.NULL);
        this.endpoint = endpoint;
        XMLMessageTemplateLoader loader = new XMLMessageTemplateLoader();
        loader.setLoadTemplateIdFromAuxId(true);
        try {
            loader.load(new FileInputStream(templatesFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.templateRegistry = loader.getTemplateRegistry();
    }

    public void encode(File xmlDataFile, MessageOutputStream out) throws FastConnectionException, IOException {
        XmlCompressedMessageConverter converter = new XmlCompressedMessageConverter();
        converter.setTemplateRegistry(this.templateRegistry);
        List messages = converter.parse(new FileInputStream(xmlDataFile));
        while (true) {
            int i = 0;
            while (i < messages.size()) {
                Message message = (Message)messages.get(i);
                out.writeMessage(message);
                ++i;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void start(File xmlDataFile) throws FastConnectionException, IOException {
        FastClient client = new FastClient(this.clientName, SessionConstants.SCP_1_0, this.endpoint);
        client.setOutboundTemplateRegistry(this.templateRegistry);
        client.setInboundTemplateRegistry(this.templateRegistry);
        client.setMessageHandler(this);
        Session session = client.connect();
        this.encode(xmlDataFile, session.out);
    }

    public void stop() {
        this.endpoint.close();
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void onMessage(Session session, Message message) {
        System.out.println("IN: " + message.toString());
    }
}

