% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_vis_sample.R
\name{dotplot_lr_continuous_group}
\alias{dotplot_lr_continuous_group}
\title{Dotplot of Ligand-Receptor Interaction Scores Against Continuous Group Variable}
\usage{
dotplot_lr_continuous_group(
  lr_scores,
  metadata,
  ligand,
  receptor,
  sender,
  receiver,
  group_by,
  score = c("normalized", "raw"),
  point_size = 3,
  point_color = "dodgerblue4",
  add_regression = TRUE,
  title = NULL
)
}
\arguments{
\item{lr_scores}{Data frame containing LR interaction scores per sample (data frame).}

\item{metadata}{Data frame containing sample metadata (data frame).}

\item{ligand}{Ligand gene name to filter (character).}

\item{receptor}{Receptor gene name to filter (character).}

\item{sender}{Sender cell type to filter (character).}

\item{receiver}{Receiver cell type to filter (character).}

\item{group_by}{Continuous variable column in \code{metadata} (e.g., age, severity score) (character).}

\item{score}{Use 'normalized' or 'raw' score (default: "normalized") (character).}

\item{point_size}{Size of the points in the plot (numeric, default: 3).}

\item{point_color}{Color of the points in the plot (default: "dodgerblue4").}

\item{add_regression}{Whether to add regression line (logical, default: TRUE).}

\item{title}{Custom plot title (optional).}
}
\value{
A list containing:
\itemize{
\item plot - ggplot object of the dotplot
\item df - data frame used for plotting
}
}
\description{
Creates a dotplot (scatter plot) of LR interaction scores against a continuous variable
with optional regression line.
}
\examples{
# Dotplot of LR Score Against Continuous Group Variable
data(lr_scores_eg)
data(metadata_eg)
res <- dotplot_lr_continuous_group(
  lr_scores_eg, metadata_eg,
  ligand = "TAC4", receptor = "TACR1",
  sender = "Perivascular", receiver = "Cardiac",
  group_by = "IFNscore"
)

print(res$plot)
head(res$df)
}
