% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R
\name{find_grid_alpha}
\alias{find_grid_alpha}
\title{Find a reasonable grid for alpha}
\usage{
find_grid_alpha(phy, alpha = NULL, nbr_alpha = 10, factor_up_alpha = 2,
  factor_down_alpha = 3, quantile_low_distance = 1e-04,
  log_transform = TRUE, ...)
}
\arguments{
\item{phy}{phylogenetic tree of class "\code{phylo}"}

\item{alpha}{fixed vector of alpha values if already known. Default to NULL.}

\item{nbr_alpha}{the number of elements in the grid}

\item{factor_up_alpha}{factor for up scalability}

\item{factor_down_alpha}{factor for down scalability}

\item{quantile_low_distance}{quantile for min distance}

\item{log_transform}{whether to take a log scale for the spacing of alpha
values. Default to TRUE.}

\item{...}{not used.}
}
\value{
A grid of alpha values
}
\description{
Grid so that 
ln(2)*quantile(d_ij)/factor_up_alpha < t_{1/2} < factor_down_alpha * ln(2) * h_tree
Ensures that for alpha_min, it is almost a BM, and for alpha_max,
almost all the tips are decorrelated.
}

