% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findIDpaths.R
\name{findIDpaths}
\alias{findIDpaths}
\title{find all paths of a certain length for an individual}
\usage{
findIDpaths(conf, ID, len = 2)
}
\arguments{
\item{conf}{a matrix of conf.mat class. An N-by-N conflict matrix whose \code{(i,j)}th element is the number of times i defeated j.}

\item{ID}{a numeric or character vector of length 1. It specifys the subject at the beginning of each pathway.}

\item{len}{a positive integer of length 1 greater than 2. the length of the win-loss paths to be identified (\eqn{len = order + 1})}
}
\value{
return all win-loss paths of \code{length(len)} beginning at \code{ID}
}
\description{
\code{findIDpaths} identifies all unique win-loss pathways of order \eqn{(len - 1)} beginning at selected \code{ID}
}
\examples{
confmatrix <- as.conflictmat(sampleEdgelist)
path38891 <- findIDpaths(confmatrix, ID = "Kuai", len = 2)
}
\seealso{
\code{\link{as.conflictmat}}, \code{\link{findAllPaths}}, \code{\link{countPaths}}
}
