% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blosumIndices.R
\name{blosumIndices}
\alias{blosumIndices}
\title{Compute the BLOSUM62 derived indices of a protein sequence}
\usage{
blosumIndices(seq)
}
\arguments{
\item{seq}{An amino-acids sequence}
}
\value{
The computed average of BLOSUM indices of all the amino acids in the corresponding peptide sequence.
}
\description{
BLOSUM indices were derived of physicochemical properties that have been subjected to a VARIMAX analyses and an alignment matrix of the 20 natural AAs using the BLOSUM62 matrix.
}
\examples{
blosumIndices(seq = "KLKLLLLLKLK")
# [[1]]
#   BLOSUM1    BLOSUM2    BLOSUM3    BLOSUM4    BLOSUM5    
# -0.4827273 -0.5618182 -0.8509091 -0.4172727  0.3172727  

#  BLOSUM6   BLOSUM7     BLOSUM8    BLOSUM9   BLOSUM10 
# 0.2527273  0.1463636  0.1427273 -0.2145455 -0.3218182 

}
\references{
Georgiev, A. G. (2009). Interpretable numerical descriptors of amino acid space. Journal of Computational Biology, 16(5), 703-723.
}
