% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smilesStrings.R
\name{aaSMILES}
\alias{aaSMILES}
\title{Create Smiles String from aminoacid sequences}
\usage{
aaSMILES(seq)
}
\arguments{
\item{seq}{character vector with one-letter aminoacid codes}
}
\value{
character vector with smiles strings
}
\description{
This function converts peptides with aminoacid one-letter abbreviations into
smiles strings to represent the structure.
}
\details{
The output can be stored in a .smi file and converted using openbabel to
drawings of the peptides.
}
\examples{
aaSMILES("AA")
# [1] "N[C@]([H])(C)C(=O)N[C@]([H])(C)C(=O)O"
aaSMILES(c("AA", "GG"))
# [1] "N[C@]([H])(C)C(=O)N[C@]([H])(C)C(=O)O" "NCC(=O)NCC(=O)O"
}
