% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrcc_identifyMonitorType.R
\name{wrcc_identifyMonitorType}
\alias{wrcc_identifyMonitorType}
\title{Identify WRCC monitor type}
\usage{
wrcc_identifyMonitorType(fileString)
}
\arguments{
\item{fileString}{character string containing WRCC data}
}
\value{
List including \code{monitorType}, \code{rawNames}, \code{columnNames} and \code{columnTypes}.
}
\description{
Examine the column names of the incoming character vector
to identify different types of monitor data provided by WRCC.

The return is a list includes everything needed to identify and parse the raw
data using \code{readr::read_tsv()}:

\itemize{
\item{\code{monitorType}}{ -- identification string}
\item{\code{rawNames}}{ -- column names from the data (including special characters)}
\item{\code{columnNames}}{ -- assigned column names (special characters repaced with '.')}
\item{\code{columnTypes}}{ -- column type string for use with \code{readr::read_csv()}}
}

The \code{monitorType} will be one of:
\itemize{
\item{"\code{WRCC_TYPE1}"}{ -- ???}
\item{"\code{WRCC_TYPE2}"}{ -- ???}
\item{"\code{UNKOWN}"}{ -- ???}
}
}
\examples{
\dontrun{
fileString <- wrcc_downloadData(20160701, 20160930, unitID='1307')
monitorTypeList <- wrcc_identifyMonitorType(fileString)
}
}
\references{
\href{http://www.wrcc.dri.edu/cgi-bin/smoke.pl}{WRCC Fire Cache Smoke Monitor Archive}
}
\keyword{WRCC}
