% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airnow_createMonitorObjects.R
\name{airnow_createMonitorObjects}
\alias{airnow_createMonitorObjects}
\title{Obain AirNow data and create ws_monitor objects}
\usage{
airnow_createMonitorObjects(parameters = NULL,
  startdate = strftime(lubridate::now(), "\%Y\%m\%d", tz = "UTC"),
  hours = 24, zeroMinimum = TRUE, addGoogleMeta = TRUE)
}
\arguments{
\item{parameters}{vector of names of desired pollutants or NULL for all pollutants}

\item{startdate}{desired start date (integer or character representing YYYYMMDD[HH])}

\item{hours}{desired number of hours of data to assemble}

\item{zeroMinimum}{logical specifying whether to convert negative values to zero}

\item{addGoogleMeta}{logicial specifying wheter to use Google elevation and reverse geocoding services}
}
\value{
List where each element contains a \emph{ws_monitor} object for a unique parameter (e.g: "PM2.5", "NOX").
}
\description{
This function uses the \link{airnow_downloadParseData} function
to download monthly dataframes of AirNow data and restructures that data into a format that is compatible
with the PWFSLSmoke package \emph{ws_monitor} data model.

AirNow data parameters include at least the following list:
\enumerate{
\item{BARPR}
\item{BC}
\item{CO}
\item{NO}
\item{NO2}
\item{NO2Y}
\item{NO2X}
\item{NOX}
\item{NOOY}
\item{OC}
\item{OZONE}
\item{PM10}
\item{PM2.5}
\item{PRECIP}
\item{RHUM}
\item{SO2}
\item{SRAD}
\item{TEMP}
\item{UV-AETH}
\item{WD}
\item{WS}
}

Setting \code{parameters=NULL} will generate a separate \emph{ws_monitor} object for each of the above parameters.
}
\note{
As of 2017-12-17, it appears that hourly data are available only for 2016 and
not for earlier years.
}
\examples{
\dontrun{
monList <- airnow_createMonitorObjects(c("O3","PM2.5"), 20160701)
pm25 <- monList$PM2.5
o3 <- monList$O3
}
}
\seealso{
\link{airnow_createDataDataframes}

\link{airnow_createMetaDataframes}
}
\keyword{AirNow}
