% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volmeranalysis.R
\name{volmeranalysis}
\alias{volmeranalysis}
\title{Volmer Isotherm Non-Linear Analysis}
\usage{
volmeranalysis(Qe, Ce)
}
\arguments{
\item{Qe}{the numerical value for the adsorbed capacity}

\item{Ce}{the numerical value for the equilibrium capacity}
}
\value{
the nonlinear regression, parameters for Aranovich isotherm,
and model error analysis
}
\description{
The Volmer isotherm describes a distribution of monolayer
adsorption processes. This theoretical model has the assumption in which
the adsorbate molecules can move toward the surfaces of adsorbents, and
the interactions that can be formed between the adsorbates are negligible.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
volmeranalysis(Qe,Ce)
}
\references{
Volmer, M. (1925) <doi:10.1515/zpch-1925-11519> Thermodynamische folgerungen aus der
zustandsgleichung fur adsorbierte stoffe. Z. Phys. Chem. 115, 253-261.
}
\author{
Keith T. Ostan

Chester C. Deocaris
}
