% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harkinsjuraLM.R
\name{harkinsjura.LM}
\alias{harkinsjura.LM}
\title{HarkinsJura Isotherm Linear Analysis}
\usage{
harkinsjura.LM(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the linear regression, parameters for the HarkinsJura isotherm,
and model error analysis
}
\description{
A model that assumes the possibility of multilayer adsorption
on the surface of absorbents having heterogenous pore distribution.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
harkinsjura.LM(Ce, Qe)
}
\references{
Harkins, W. D., & Jura, G. (1944) <doi:10.1021/ja01236a048>
Surfaces of solids. XIII. A vapor adsorption method for the determination of the
area of a solid withoutthe assumption of a molecular area, and the areas occupied
by nitrogen and other molecules on the surface of a solid. Journal of the American
Chemical Society, 66(8), 1366-1373.
}
\author{
Paul Angelo C. Manlapaz

Chester C. Deocaris
}
