% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pnds.R
\name{read_pnds}
\alias{read_pnds}
\title{Read PNDS microdata}
\usage{
read_pnds(microdata, input_txt, vars = NULL)
}
\arguments{
\item{microdata}{A text file containing microdata from PNDS survey, available on official website: (select a microdata file, according to the appropriated year, microdata folder and then, inside, data) - \samp{https://ftp.ibge.gov.br/PNDS/}.}

\item{input_txt}{A text file, related to the microdata, containing the input script for SAS, available on official website: (select the dictionary and input zip file, according to the appropriated year, microdata folder and then, inside, documentation) - \samp{https://ftp.ibge.gov.br/PNDS/}.}

\item{vars}{Vector of variable names to be kept for analysis. Default is to keep all variables.}
}
\value{
A tibble with selected variables of the microdata, including the necessary survey design ones.
}
\description{
This function reads PNDS microdata.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/saude/9160-pesquisa-nacional-de-demografia-e-saude.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
input_path <- pnds_example(path="input_example.txt")
data_path <- pnds_example(path="exampledata.txt")
pnds.df <- read_pnds(microdata=data_path, input_txt=input_path, vars=c("J007","J009"))
pnds.df <- pnds.df[(pnds.df$M001 == "1" & !is.na(pnds.df$M001)),]
pnds.df <- pnds.df[,!(names(pnds.df) \%in\% c("V0029", "V00291", "V00292", "V00293"))]
}
\seealso{
\link[PNDSIBGE]{get_pnds} for downloading, labeling, deflating and creating survey design object for PNDS microdata.\cr \link[PNDSIBGE]{pnds_labeller} for labeling categorical variables from PNDS microdata.\cr \link[PNDSIBGE]{pnds_deflator} for adding deflator variables to PNDS microdata.\cr \link[PNDSIBGE]{pnds_design} for creating PNDS survey design object.\cr \link[PNDSIBGE]{pnds_example} for getting the path of the PNDS toy example files.
}
