% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_complementary_functions.R
\name{peptest}
\alias{peptest}
\title{Bayes factor for model comparison}
\usage{
peptest(formula1, formula2, data, intrinsic = FALSE, reference.prior = TRUE)
}
\arguments{
\item{formula1}{One of the two formulas/models to be compared.}

\item{formula2}{The second formula/model. The one model 
needs to be nested to the other.}

\item{data}{A data frame (of numeric values), containing the data.}

\item{intrinsic}{Logical, indicating whether the PEP 
(\code{FALSE}) or the intrinsic --- which   
is a special case of it --- (\code{TRUE}) should be used as prior on the  
regression parameters. Default value=\code{FALSE}.}

\item{reference.prior}{Logical, indicating whether the reference prior
(\code{TRUE}) or the dependence Jeffreys prior (\code{FALSE}) is used as 
baseline. Default value=\code{TRUE}.}
}
\value{
\code{peptest} returns the Bayes factor, i.e., a numeric value.
For the ratio, the marginal likelihood of the more complex model (nominator)
with respect to that of the simpler one (denominator) is computed. 
Both marginal likelihoods are computed with respect
to the intercept--only model (reference model).
}
\description{
Given two models to be compared (the one nested to the other), 
computes the corresponding Bayes factor.
}
\details{
This function can be used to perform hypothesis testing indirectly. More
specifically, for the interpretation of the result (Bayes factor), the table in 
Kass and Raftery (1995) can be used.

The function works when \eqn{p\leq n-2}, where \eqn{p} is the number of explanatory 
variables in the more complex model and \eqn{n} is the sample size.

The case of missing data (i.e., presence of \code{NA}'s either in the  
data matrix corresponding to the explanatory variables of the more complex 
model or the response vector) is not currently supported. Further, the
explanatory variables of the more complex model need to be quantitative.

If \eqn{p>1}, the explanatory variables of the more complex model 
cannot have an exact linear relationship (perfect multicollinearity).
}
\examples{
data(UScrime_data)
resBF1 <- peptest(y~1,y~M+Ed,UScrime_data)
resBF1i <- peptest(y~1,y~M+Ed,UScrime_data, intrinsic=TRUE)
resBF2j <- peptest(y~M+Ed+Po1+Po2,y~M+Ed,UScrime_data,
                   reference.prior=FALSE)
resBF2ij <- peptest(y~M+Ed+Po1+Po2,y~M+Ed,UScrime_data,
                    intrinsic=TRUE, reference.prior=FALSE)

}
\references{
Kass, R. and Raftery, A. (1995) Bayes Factors. 
Journal of the American Statistical Association, 90(430): 773–795. 
\doi{10.1080/01621459.1995.10476572}
}
