% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano_plot.R
\name{volcano_plot}
\alias{volcano_plot}
\title{Volcano plot}
\usage{
volcano_plot(
  data,
  logfold_col,
  pvalue_col,
  feature_rank,
  abundance_col,
  pvalue.threshold = 0.05,
  logfold.threshold = 0.6,
  abundance.threshold = 0.01,
  label_A = "A",
  label_B = "B"
)
}
\arguments{
\item{data}{A \link[data.table]{data.table}.}

\item{logfold_col}{A column name of a continuous variable.}

\item{pvalue_col}{A column name of a continuous variable.}

\item{feature_rank}{A character variable of the feature column.}

\item{abundance_col}{A column name of a continuous variable.}

\item{pvalue.threshold}{A P-value threshold (default: 0.05).}

\item{logfold.threshold}{A Log2(A/B) Fold Change threshold (default: 0.6).}

\item{abundance.threshold}{An abundance threshold (default: 0.01).}

\item{label_A}{A character to describe condition A.}

\item{label_B}{A character to describe condition B.}
}
\value{
A \link[ggplot2]{ggplot2} object to be further modified.
}
\description{
Creates a Volcano plot from the output of \link{foldchange}, it plots the foldchanges on the x-axis,
log10 trasnformed p-values on the y-axis and adjusts the scatter size based on the percentage abundance of the features.
This function is built into the class \link{omics} with method \code{DFE()} and inherited by other omics classes, such as;
\link{metagenomics} and \link{proteomics}.
}
\examples{
library(data.table)
library(ggplot2)

# Create mock data frame
mock_volcano_data <- data.table(

  # Feature names (feature_rank)
  Feature = paste0("Gene", 1:20),   

  # Log2 fold changes (X)        
  log2FC = c(1.2, -1.5, 0.3, -0.7, 2.3,    
             -2.0, 0.1, 0.5, -1.0, 1.8,
             -0.4, 0.7, -1.4, 1.5, 0.9,
             -2.1, 0.2, 1.0, -0.3, -1.8),
  
  # P-values (Y)
  pvalue = c(0.001, 0.02, 0.3, 0.04, 0.0005, 
             0.01, 0.7, 0.5, 0.02, 0.0008,
             0.15, 0.06, 0.01, 0.005, 0.3,
             0.02, 0.8, 0.04, 0.12, 0.03),
  
  # Mean (relative) abundance for point sizing
  rel_abun = runif(20, 0.01, 0.1)            
)

volcano_plot(
  data = mock_volcano_data,
  logfold_col = "log2FC",
  pvalue_col = "pvalue",
  abundance_col = "rel_abun",
  feature_rank = "Feature",
)
}
