% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/means.R
\name{means}
\alias{means}
\title{calculate arithmetic or geometric mean and confidence intervals}
\usage{
means(
  x,
  type = "arithmetic",
  na.rm = FALSE,
  z.rm = FALSE,
  ci = FALSE,
  dist.ci = "t",
  p.ci = 0.95,
  colnames = c("est", "ll", "ul"),
  format = "df"
)
}
\arguments{
\item{x}{vector to calculate the geometric mean of}

\item{type}{type of mean or median. Default is arithmetic,
geometric and median are available as well. Only first letters
needed, so say "geo" or even "g" is enough.}

\item{na.rm}{Remove NA's before doing calculations?}

\item{z.rm}{removes zeros before calculation? Default is
FALSE. Can only be TRUE if type="geometric".}

\item{ci}{if TRUE, a data.frame including point estimate and
confidence interval returned. If FALSE, a numeric representing
the mean value returned.}

\item{dist.ci}{The distribution to use for the confidence
interval. Default and only supported is "t". If
type=geometric, this is applied after transformation to
gaussian.}

\item{p.ci}{probability covered by confidence interval. Default is
0.95}

\item{colnames}{If ci, this defines the column names of the
resulting data frame. Default is c("est","ll","ul").}

\item{format}{The format of the result. Possible values are df and
num.}
}
\value{
If ci=FALSE, a numeric. If ci=TRUE, a data.frame.
}
\description{
calculate arithmetic or geometric mean and confidence intervals
}
\examples{
x <- 1:100
means(x, type="arithmetic", ci=TRUE)
means(x, type="geometric", ci=TRUE)
means(x, type="median", ci=TRUE)
library(data.table)
## CRAN requires examples to run on a single thread
data.table::setDTthreads(1)
data.table(x=x)[,append(means(x,ci=TRUE),list(N=.N))]
}
