% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_standards_carbon.R
\name{calibrate_standards_carbon}
\alias{calibrate_standards_carbon}
\title{calibrate_standards_carbon}
\usage{
calibrate_standards_carbon(
  cal_df,
  ref_df,
  f = 0.00474,
  r2_thres = 0.95,
  correct_bad_refvals = FALSE,
  site,
  refGas
)
}
\arguments{
\item{cal_df}{Data.frame containing calibration parameters}

\item{ref_df}{Data.frame containing reference gas measurements}

\item{f}{Fraction of CO2 isotopologues that are not 12CO2 or 13CO2.
Inherited from script calling this function.}

\item{r2_thres}{Threshold for calibration regression to be used to
calibrate standards data. Default is 0.95. Calibrated reference
gas measurements occurring during calibration periods
with r2 values less than \code{r2_thres} will be marked NA.}

\item{correct_bad_refvals}{Should we correct known/suspected incorrect
reference values in the NEON HDF5 files? (Default = \code{FALSE}).}

\item{site}{Four letter NEON site code.
Only used if \code{correct_bad_refvals = TRUE}.}

\item{refGas}{One of "low", "med", or "high."
Only used if \code{correct_bad_refvals = TRUE}.}
}
\value{
A data.frame having the same number of rows of \code{cal_df}, with
additional columns added for calibrated CO2 mole fractions
and d13C values.
}
\description{
calibrate_standards_carbon
}
\author{
Rich Fiorella \email{rich.fiorella@utah.edu}
}
