% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GVAR.R
\name{GVAR}
\alias{GVAR}
\title{Estimates a GVAR(1) and a VARX(1,1,1) models}
\usage{
GVAR(GVARinputs, N, CheckInputs = FALSE)
}
\arguments{
\item{GVARinputs}{List of inputs for GVAR model estimation:
\enumerate{
       \item  \code{Economies}:  A character vector containing the names of the economies included in the system.
       \item  \code{GVARFactors}: A list of all variables used in the estimation of the VARX model \cr
               (see e.g. \code{CM_Factors_GVAR} file for details);
       \item \code{VARXtype}: A character vector with three possible options:
 \itemize{
       \item \code{'unconstrained'}: model is estimated without constraints (each equation is estimated individually by ordinary least square);
       \item \code{'constrained: Spanned Factors'}: The model is estimated with the restriction that foreign pricing factors do NOT
                               affect (i) domestic economic variables and (ii) domestic pricing factors. \cr
                              (Equations are estimated using restricted least squares)
       \item \code{'constrained : [factor_name]'}: The model is estimated with the restriction that the specified risk factor
             is influenced only by its own lagged values and the lagged values of its corresponding star variables.
       (Equations are estimated using restricted least squares.)
         }
         \item \code{Wgvar}: The GVAR transition matrix (C x C) used in the model solution. \cr
                               (See the output from the \code{\link{Transition_Matrix}} function.).
}}

\item{N}{Integer. Number of country-specific spanned factors.}

\item{CheckInputs}{A logical flag to indicate whether to perform a prior consistency check on the inputs provided in \code{GVARinputs}. The default is set to FALSE}
}
\value{
A list containing
\enumerate{
\item parameters of the country-specific VARX(1,1,1)
\itemize{
\item intercept (M+Nx1);
\item phi_1   (M+N x M+N);
\item phi_1^star (M+N x M+N);
\item phi_g (M+N x M+N);
\item Sigma (M+N x G)
}
\item parameters of the GVAR.
\itemize{
\item F0 (F X 1);
\item F1 (F x F);
\item Sigma_y (F x F)
}
}
}
\description{
Estimates a GVAR(1) and a VARX(1,1,1) models
}
\examples{
data(CM_Factors_GVAR)

GVARinputs <- list( Economies = c("China", "Brazil", "Mexico", "Uruguay"),
                    GVARFactors = FactorsGVAR, VARXtype = "unconstrained")

GVARinputs$Wgvar <- matrix( c(0, 0.83, 0.86, 0.38,
                              0.65, 0, 0.13, 0.55,
                              0.32, 0.12, 0, 0.07,
                              0.03, 0.05, 0.01, 0), nrow = 4, ncol = 4)
N <- 3

GVARPara <- GVAR(GVARinputs, N)

}
\references{
Chudik and Pesaran, (2016). "Theory and Practice of GVAR modelling" (Journal of Economic Surveys)
}
