% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/life_table.R
\name{life.table}
\alias{life.table}
\title{Life Table Function}
\usage{
life.table(mx, sex = c("male", "female", "total"), abridged = TRUE,
  radix = 1, open.age = 130)
}
\arguments{
\item{mx}{Vector of age-specific mortality rates nmx. If \code{abridged} is \code{TRUE} (default), 
the elements correspond to 1m0, 4m1, 5m5, 5m10, \dots. 
If \code{abridged} is \code{FALSE}, they correspond to 1m0, 1m1, 1m2, 1m3, \dots.}

\item{sex}{Which sex the mortality rates correspond to.}

\item{abridged}{Is it an abridged life table (\code{TRUE}, default) or not (\code{FALSE}). 
In the former case, the \code{mx} vector is interpreted as corresponding to age groups 0, 1-4, 5-9, 10-14, \dots.
If \code{FALSE}, the \code{mx} vector is interpreted as corresponding to one-year age groups, i.e. 0, 1, 2, 3, \dots.}

\item{radix}{Base of the life table.}

\item{open.age}{Open age group. If smaller than the last age group of \code{mx}, the life table is truncated. 
It does not have any effect if larger than the last age group.}
}
\description{
Function for obtaining life table quantities from mortality rates.
}
\details{
Computes a life table corresponding to given mortality rates for either 5- or 1-year age groups. The implementation follows
   Preston et al. (2001), including the choice of ax (see Table 3.3 on page 48). 
   For compatibility with computations done at the UN, we set ax for ages 5 and 10 
   (in the abridged version) to 2.5.
}
\examples{
data(mxF, e0Fproj, package = "wpp2017")
# get female mortality of Mexico for the current year
country <- "Mexico"
mxf <- subset(mxF, name == country)[,"2010-2015"]
life.table(mxf, sex = "female")

}
\references{
Preston, S.H., Heuveline, P., Guillot, M. (2001). Demography: Measuring and Modeling Population Processes. Oxford: Blackwell Publishers Ltd.
}
