% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-ldk-utilities.R
\name{ldk_check}
\alias{ldk_check}
\title{Checks 'ldk' shapes}
\usage{
ldk_check(ldk)
}
\arguments{
\item{ldk}{a \code{matrix} of (x; y) coordinates, a list, or an array.}
}
\value{
an \code{array} of (x; y) coordinates.
}
\description{
A simple utility, used internally, mostly by \link{Ldk} methods,
in some graphical functions, and notably in \link{l2a}.
Returns an array of landmarks arranged as \code{(nb.ldk) x (x; y) x (nb.shapes)},
when passed with either a list, a matrix or an array of coordinates.
If a list is provided, checks that the number of landmarks is consistent.
}
\examples{
#coo_check('Not a shape')
#coo_check(matrix(1:10, ncol=2))
#coo_check(list(x=1:5, y=6:10))
}
\seealso{
Other ldk helpers: 
\code{\link{def_links}()},
\code{\link{links_all}()},
\code{\link{links_delaunay}()}
}
\concept{ldk helpers}
