% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-NMDS.R
\name{NMDS}
\alias{NMDS}
\title{Non metric multidimensional scaling}
\usage{
NMDS(x, distance = "bray", k = 2, try = 20, trymax = 20, ...)
}
\arguments{
\item{x}{any \link{Coe} object}

\item{distance}{a dissiminarity index to feed \link[vegan:vegdist]{vegan::vegdist} (default: \code{bray})}

\item{k}{\code{numeric} number of dimensions to feed \link[vegan:metaMDS]{vegan::metaMDS} (default: 2)}

\item{try}{\code{numeric} minimum number of random starts to feed \link[vegan:metaMDS]{vegan::metaMDS} (default: 20)}

\item{trymax}{\code{numeric} minimum number of random starts to feed \link[vegan:metaMDS]{vegan::metaMDS} (default: 20)}

\item{...}{additional parameters to feed \link[vegan:metaMDS]{vegan::metaMDS}}
}
\value{
what is returned by \link[vegan:metaMDS]{vegan::metaMDS} plus \verb{$fac}. And prepend \code{NMDS} class to it.
}
\description{
A wrapper around \link[vegan:metaMDS]{vegan::metaMDS}.
}
\details{
For Details, see \link[vegan:metaMDS]{vegan::metaMDS}
}
\examples{
x <- bot \%>\% efourier \%>\% NMDS

# Shepard diagram # before a Momocs wrapper
# vegan::stressplot(x)

}
\seealso{
Other multivariate: 
\code{\link{CLUST}()},
\code{\link{KMEANS}()},
\code{\link{KMEDOIDS}()},
\code{\link{LDA}()},
\code{\link{MANOVA_PW}()},
\code{\link{MANOVA}()},
\code{\link{MDS}()},
\code{\link{MSHAPES}()},
\code{\link{PCA}()},
\code{\link{classification_metrics}()}
}
\concept{multivariate}
