% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_dep_ser.R
\name{stat_dep_ser}
\alias{stat_dep_ser}
\title{Computes the Kendall's taus and Spearman's rho for tests of randomness}
\usage{
stat_dep_ser(x, lag)
}
\arguments{
\item{x}{time series}

\item{lag}{number of lags.}
}
\value{
\item{tau}{Kendall's taus for lags 1:lag}

\item{rho}{Spearman's rhos for lags 1:lag}
}
\description{
This function Computes the Kendall's taus and Spearman's rho for tests of randomness.
}
\examples{
X <- SimAR1Poisson(c(5,0.2),100)
out <- stat_dep_ser(X,10)

}
\references{
B.R Nasri (2021). Test of serial dependence for arbitrary distributions
}
\keyword{internal}
