% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts_collapse.R
\name{mts_collapse}
\alias{mts_collapse}
\title{Collapse an \emph{mts} time series object into a single time series}
\usage{
mts_collapse(
  mts,
  longitude = NULL,
  latitude = NULL,
  deviceID = "generatedID",
  FUN = mean,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{mts}{\emph{mts} object.}

\item{longitude}{Longitude of the collapsed time series.}

\item{latitude}{Latitude of the collapsed time series.}

\item{deviceID}{Device identifier for the collapsed time series.}

\item{FUN}{Function used to collapse multiple time series.}

\item{na.rm}{Logical specifying whether NA values should be ignored when FUN
is applied.}

\item{...}{additional arguments to be passed on to the \code{apply()} function.}
}
\value{
An \emph{mts} time series object representing a single time series.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
Collapses data from all time series in \code{mts} into a
single-time series \emph{mts} object using the function provided in the
\code{FUN} argument. The single-time series result will be located at the mean
longitude and latitude unless \code{longitude} and \code{latitude}
are specified.

Any columns of \code{mts$meta} that are constant across all records will be
retained in the returned \code{mts$meta}.

The core metadata associated with this location (\emph{e.g.}
\code{countryCode, stateCode, timezone, ...}) will be determined from
the most common (or average) value found in \code{mts$meta}. This will be
a reasonable assumption for the vast majority of intended use cases where
data from multiple devices in close proximity are averaged together.
}
\note{
After \code{FUN} is applied, values of \code{+/-Inf} and \code{NaN} are
converted to \code{NA}. This is a convenience for the common case where
\code{FUN = min/max} or \code{FUN = mean} and some of the time steps have all
missing values. See the R documentation for \code{min} for an explanation.
}
\examples{
library(MazamaTimeSeries)

mon <-
  mts_collapse(
    mts = example_mts,
    deviceID = "example_ID"
  )

# mon$data now only has 2 columns
names(mon$data)

plot(mon$data, type = 'b', main = mon$meta$deviceID)

}
