% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location_getSingleElevation_USGS.R
\name{location_getSingleElevation_USGS}
\alias{location_getSingleElevation_USGS}
\title{Get elevation data from a USGS web service}
\usage{
location_getSingleElevation_USGS(
  longitude = NULL,
  latitude = NULL,
  verbose = TRUE
)
}
\arguments{
\item{longitude}{Single longitude in decimal degrees E.}

\item{latitude}{Single latitude in decimal degrees N.}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Numeric elevation value.
}
\description{
USGS APIs are used to determine the elevation in meters
associated with the \code{longitude} and \code{latitude}.

\emph{Note: The conversion factor for meters to feet is 3.28084.}
}
\examples{
\donttest{
library(MazamaLocationUtils)

# Fail gracefully if any resources are not available
try({

  # Wenatchee
  lon <- -120.325278
  lat <- 47.423333

  location_getSingleElevation_USGS(lon, lat)
  
}, silent = FALSE)
}

}
\references{
\url{https://nationalmap.gov/epqs/}
}
