% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ARmdl}
\alias{ARmdl}
\title{Autoregressive Model}
\usage{
ARmdl(Y, p, control = list())
}
\arguments{
\item{Y}{A \code{(T x 1)} matrix of observations.}

\item{p}{Integer determining the number of autoregressive lags.}

\item{control}{List with model options including: 
\itemize{
  \item const: Boolean determining whether to estimate model with constant if \code{TRUE} or not if \code{FALSE}. Default is \code{TRUE}.
  \item getSE: Boolean determining whether to compute standard errors of parameters if \code{TRUE} or not if \code{FALSE}. Default is \code{TRUE}.
}}
}
\value{
List of class \code{ARmdl} (\code{S3} object) with model attributes including:
\itemize{
  \item y: a \code{(T-p x 1)} matrix of observations.
  \item X: a \code{(T-p x p + const)} matrix of lagged observations with a leading column of \code{1}s if \code{const=TRUE} or not if \code{const=FALSE}.
  \item x: a \code{(T-p x p)} matrix of lagged observations.
  \item fitted: a \code{(T-p x 1)} matrix of fitted values.
  \item resid: a \code{(T-p x 1)} matrix of residuals.
  \item inter: estimated intercept of the process.
  \item mu: estimated mean of the process.
  \item coef: coefficient estimates. First value is the intercept (i.e., not \code{mu}) if \code{const=TRUE}. This is the same as \code{phi} if \code{const=FALSE}.
  \item intercept: estimate of intercept.
  \item phi: estimates of autoregressive coefficients.
  \item stdev: estimated standard deviation of the process.
  \item sigma: estimated variance of the process.
  \item theta: vector containing: \code{mu}, \code{sigma}, and \code{phi}.
  \item theta_mu_ind: vector indicating location of mean with \code{1} and \code{0} otherwise.
  \item theta_sig_ind: vector indicating location of variance with \code{1} and \code{0} otherwise.
  \item theta_var_ind: vector indicating location of variance with \code{1} and \code{0} otherwise. This is the same as \code{theta_sig_ind} in \code{ARmdl}.
  \item theta_phi_ind: vector indicating location of autoregressive coefficients with \code{1} and \code{0} otherwise.
  \item stationary: Boolean indicating if process is stationary if \code{TRUE} or non-stationary if \code{FALSE}.
  \item n: number of observations after lag transformation (i.e., \code{n = T-p}).
  \item p: number of autoregressive lags.
  \item q: number of series. This is always \code{1} in \code{ARmdl}.
  \item k: number of regimes. This is always \code{1} in \code{ARmdl}.
  \item control: List with model options used.
  \item logLike: log-likelihood.
  \item AIC: Akaike information criterion.
  \item BIC: Bayesian (Schwarz) information criterion.
  \item Hess: Hessian matrix. Approximated using \code{\link[numDeriv]{hessian}} and only returned if \code{getSE=TRUE}.
  \item info_mat: Information matrix. Computed as the inverse of \code{-Hess}. If matrix is not PD then nearest PD matrix is obtained using \code{\link[pracma]{nearest_spd}}. Only returned if \code{getSE=TRUE}.
  \item nearPD_used: Boolean determining whether \code{nearPD} function was used on \code{info_mat} if \code{TRUE} or not if \code{FALSE}. Only returned if \code{getSE=TRUE}.
  \item theta_se: standard errors of parameters in \code{theta}.  Only returned if \code{getSE=TRUE}.
}
}
\description{
This function estimates an autoregresive model with \code{p} lags. This can be used for the null hypothesis of a linear model against an alternative hypothesis of a Markov switching autoregressive model with \code{k} regimes.
}
\examples{
set.seed(1234)
# Define DGP of AR process
mdl_ar <- list(n     = 500, 
               mu    = 5,
               sigma = 2,
               phi   = c(0.5,0.2))

# Simulate process using simuAR() function
y_simu <- simuAR(mdl_ar)

# Set options for model estimation
control <- list(const  = TRUE, 
                getSE  = TRUE)

# Estimate model
y_ar_mdl <- ARmdl(y_simu$y, p = 2, control)
y_ar_mdl

}
\seealso{
\code{\link{MSARmdl}}
}
