% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/miive.R
\name{miive}
\alias{miive}
\title{Model-implied instrumental variable (MIIV) estimation}
\usage{
miive(model = model, data = data, instruments = NULL, overid = NULL)
}
\arguments{
\item{model}{A model specified using lavaan model syntax. See the \code{model} argument within the \code{\link[lavaan]{lavaanify}} function for more information.}

\item{data}{A data frame, list or environment or an object coercible by as.data.frame to data frame.}

\item{instruments}{A user-supplied list of valid MIIVs for each equation. See Example 2 below.}

\item{overid}{A user-specified degree of overidentification (\code{overid}). See Example 3 below.}
}
\value{
model

dat

modeeqns
}
\description{
Estimate SEM models using MIIV-2SLS.
}
\details{
\itemize{
 \item{\code{overid}} {If the user-specified degree of overidentification (\code{overid}) exceeds the number of available MIIVs for a given equation, the maximum number of MIIVs will be used instead.  In this case, the \code{df} column for any equations in which the degrees of freedom for the \code{Sargan} test are less than the \code{overid} value will be appended with an \code{*}. A note willalso  be displayed to alert the user to the changes. In the example below, the \code{overid} parameter is set to 2, however the \code{y1} equation has only 1 additional MIIV avaialable.}
\item{\code{instruments}} {Using the \code{instruments} option you can specify the MIIVs directly for each equation in the model.  To utilize this option you must first define a list of instruments using the syntax displayed below. After the list is defined, set the \code{instruments} argument equal to the name of the list of MIIVs. Note, \code{instruments} are specified for an equation, and not for a specific endogenous variable.}
}
}
\examples{
# Example 1

 bollen1989a_model <- '

   Eta1 =~ y1 + y2  + y3  + y4
   Eta2 =~ y5 + y6  + y7  + y8
   Xi1  =~ x1 + x2 + x3

   Eta1 ~ Xi1
   Eta2 ~ Xi1
   Eta2 ~ Eta1

   y1   ~~ y5
   y2   ~~ y4
   y2   ~~ y6
   y3   ~~ y7
   y4   ~~ y8
   y6   ~~ y8
 '

  miive(model = bollen1989a_model, data = bollen1989a)


# Example 2

  my_instruments <- '
   y1 ~ x2 + x3
   y5 ~ y2 + y3 + y4 + x2
   y2 ~ y3 + y7 + y8 + x2
   y3 ~ y2 + y4 + y6 + y8
   y4 ~ y3 + y6
   y6 ~ y3 + y4 + y7 + x2
   y7 ~ y2 + y4 + y6 + y8
   y8 ~ y2 + y3 + y7 + x2
   x2 ~ y1 + y5 + y2 + y3 + y4 + y6
   x3 ~ y1 + y5 + y2 + y3 + y4 + y6
 '

miive(model = bollen1989a_model, data = bollen1989a,
      instruments = my_instruments)


# Example 3

 miive(model = bollen1989a_model, data = bollen1989a, overid = 2)
}
\references{
Bollen, K. A. 1996.	An	Alternative	2SLS Estimator	for	Latent
Variable	Models.	\emph{Psychometrika}, 61, 109-121.

Bollen,	K. A. 2001.	Two-stage	Least	Squares	and	Latent	Variable	Models:
Simultaneous	Estimation	and	Robustness	to	Misspecifications.
In	R.	Cudeck,	S.	Du	Toit,	and	D.	Sorbom	(Eds.),	Structural
Equation	Modeling:	Present	and	Future,	A	Festschrift	in	Honor	of	Karl
Joreskog	(pp. 119-138).	Lincoln,	IL: Scientific	Software.
}

