% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LncFinder.R
\name{compute_GC}
\alias{compute_GC}
\title{Calculate GC content}
\usage{
compute_GC(
  Sequences,
  label = NULL,
  on.ORF = FALSE,
  auto.full = FALSE,
  parallel.cores = 2
)
}
\arguments{
\item{Sequences}{A FASTA file loaded by function  \code{\link[seqinr]{read.fasta}} of
\code{\link[seqinr]{seqinr-package}}.}

\item{label}{Optional. String. Indicate the label of the sequences such as
"NonCoding", "Coding".}

\item{on.ORF}{Logical. If \code{TRUE}, GC content will be calculated on
the longest ORF region.}

\item{auto.full}{Logical. When \code{on.ORF = TRUE} but no ORF can be found,
if \code{auto.full = TRUE},  GC content will be calculated on full sequences automatically;
if \code{auto.full} is \code{FALSE}, the sequences that have no ORF will be discarded.
Ignored when \code{on.ORF = FALSE}. (Default: \code{FALSE})}

\item{parallel.cores}{Integer. The number of cores for parallel computation.
By default the number of cores is \code{2}. Users can set as \code{-1} to run
this function with all cores.}
}
\value{
A dataframe.
}
\description{
This function can GC content of the input sequences.
}
\details{
This function can basically compute GC content of DNA sequences:
GC content = (nc + ng) / (na + nc + ng + nt).
The function will ignored the ambiguous bases.
}
\examples{
\dontrun{
data(demo_DNA.seq)
Seqs <- demo_DNA.seq

gcContent <- compute_GC(Seqs, label = "NonCoding",on.ORF = TRUE,
                        auto.full = TRUE, parallel.cores = 2)
}
}
\seealso{
\code{\link[seqinr]{GC}} (package "\code{\link[seqinr]{seqinr-package}}")
}
\author{
HAN Siyu
}
