% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LOPART_interface}
\alias{LOPART_interface}
\title{Labeled Optimal Partitioning interface}
\usage{
LOPART_interface(
  input_data,
  input_label_start,
  input_label_end,
  input_label_changes,
  n_updates,
  penalty_unlabeled,
  penalty_labeled = 0
)
}
\arguments{
\item{input_data}{numeric vector of N data to segment}

\item{input_label_start}{integer vector of label start positions
in 0, ..., N-2}

\item{input_label_end}{integer vector of label end positions in 1,
..., N-1}

\item{input_label_changes}{integer vector of 0/1, number of
labeled changes}

\item{n_updates}{number of dynamic programming updates to perform,
usually should be number of input_data N, but can be less if you
want to analyze/plot the cost/candidates at previous data.}

\item{penalty_unlabeled}{non-negative numeric scalar (bigger for
fewer changes in unlabeled regions, smaller for more changes)}

\item{penalty_labeled}{non-negative numeric scalar (penalty for
each change in a positive label).}
}
\value{
data frame with four columns: cost_candidates is the cost
  of each last segment start considered (from 1 to N) for the
  computation of the optimal cost up to the last data point (Inf
  means infeasible); cost_optimal is the optimal cost vector
  computed using dynamic programming; mean is the last segment
  mean of the optimal model ending at that data point; last_change
  is the optimal changepoints (negative numbers are not used).
}
\description{
Low-level interface to LOPART C code
}
\details{
Avoid using this function and instead use the LOPART function.
}
\author{
Toby Dylan Hocking
}
