# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Low-level interface to LOPART C code
#'
#' Avoid using this function and instead use the LOPART function.
#' @title Labeled Optimal Partitioning interface
#' @param input_data numeric vector of N data to segment
#' @param input_label_start integer vector of label start positions
#'   in 0, ..., N-2
#' @param input_label_end integer vector of label end positions in 1,
#'   ..., N-1
#' @param input_label_changes integer vector of 0/1, number of
#'   labeled changes
#' @param n_updates number of dynamic programming updates to perform,
#'   usually should be number of input_data N, but can be less if you
#'   want to analyze/plot the cost/candidates at previous data.
#' @param penalty_unlabeled non-negative numeric scalar (bigger for
#'   fewer changes in unlabeled regions, smaller for more changes)
#' @param penalty_labeled non-negative numeric scalar (penalty for
#'   each change in a positive label).
#' @return data frame with four columns: cost_candidates is the cost
#'   of each last segment start considered (from 1 to N) for the
#'   computation of the optimal cost up to the last data point (Inf
#'   means infeasible); cost_optimal is the optimal cost vector
#'   computed using dynamic programming; mean is the last segment
#'   mean of the optimal model ending at that data point; last_change
#'   is the optimal changepoints (negative numbers are not used).
#' @author Toby Dylan Hocking
LOPART_interface <- function(input_data, input_label_start, input_label_end, input_label_changes, n_updates, penalty_unlabeled, penalty_labeled = 0) {
    .Call(`_LOPART_LOPART_interface`, input_data, input_label_start, input_label_end, input_label_changes, n_updates, penalty_unlabeled, penalty_labeled)
}

