% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PerformanceMetrics.R
\name{PerformanceMetrics}
\alias{PerformanceMetrics}
\title{Report table with the performance metrics for tree-based learning methods}
\usage{
PerformanceMetrics(
  testdata,
  DT = NULL,
  RF = NULL,
  GBM = NULL,
  outcome,
  reflevel
)
}
\arguments{
\item{testdata}{A test dataset that contains the study’s features and the outcome variable.}

\item{DT}{A fitted decision tree model object}

\item{RF}{A fitted random forest model object}

\item{GBM}{A fitted gradient boosting model object}

\item{outcome}{A factor variable with the outcome levels.}

\item{reflevel}{A character string with the quoted reference level of outcome.}
}
\value{
This function returns a \code{data.frame} with a table that compares five performance metrics from different tree-based machine learning methods. The metrics are: Accuracy, Kappa, Sensitivity, Specificity, and Precision. The results are derived from the confusionMatrix function from the caret package.
}
\description{
Report table with the performance metrics for tree-based learning methods
}
\examples{
\donttest{
colnames(training)[14] <- "perf"
ensemblist <- TreeModels(traindata = training,
methodlist = c("dt", "rf","gbm"),checkprogress = TRUE)

PerformanceMetrics(testdata = testing, RF = ensemblist$ModelObject$ranger,
outcome = "outcome", reflevel = "correct")

PerformanceMetrics(testdata = testing, RF = ensemblist$ModelObject$ranger,
GBM = ensemblist$ModelObject$gbm,
outcome = "outcome", reflevel = "correct")

PerformanceMetrics(testdata = testing, DT = ensemblist$ModelObject$rpart,
RF = ensemblist$ModelObject$ranger, GBM = ensemblist$ModelObject$gbm,
outcome = "outcome", reflevel = "correct")
}
}
